/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.common.ListAccessValidator;
import org.exoplatform.social.common.jcr.Util;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class ProfileFilterListAccess
implements ListAccess<Identity> {
    private static final char EMPTY_CHARACTER = '\u0000';
    private IdentityStorage identityStorage;
    private ProfileFilter profileFilter;
    String providerId;
    boolean forceLoadProfile;
    Type type;

    public ProfileFilterListAccess(IdentityStorage identityStorage, String providerId, ProfileFilter profileFilter, boolean forceLoadProfile) {
        this.identityStorage = identityStorage;
        this.profileFilter = profileFilter;
        this.providerId = providerId;
        this.forceLoadProfile = forceLoadProfile;
    }

    public ProfileFilterListAccess(IdentityStorage identityStorage, String providerId, ProfileFilter profileFilter, boolean forceLoadProfile, Type type) {
        this.identityStorage = identityStorage;
        this.profileFilter = profileFilter;
        this.providerId = providerId;
        this.forceLoadProfile = forceLoadProfile;
        this.type = type;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public Identity[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        ListAccessValidator.validateIndex((int)offset, (int)limit, (int)this.getSize());
        List<Object> identities = new ArrayList();
        if (this.type != null) {
            switch (this.type) {
                case UNIFIED_SEARCH: {
                    identities = this.identityStorage.getIdentitiesForUnifiedSearch(this.providerId, this.profileFilter, offset, limit);
                }
            }
        } else {
            identities = this.profileFilter.getFirstCharacterOfName() != '\u0000' ? this.identityStorage.getIdentitiesByFirstCharacterOfName(this.providerId, this.profileFilter, offset, limit, this.forceLoadProfile) : this.identityStorage.getIdentitiesForMentions(this.providerId, this.profileFilter, offset, limit, this.forceLoadProfile);
        }
        return (Identity[])Util.convertListToArray(identities, Identity.class);
    }

    public int getSize() throws Exception {
        int size = 0;
        size = this.profileFilter.getFirstCharacterOfName() != '\u0000' ? this.identityStorage.getIdentitiesByFirstCharacterOfNameCount(this.providerId, this.profileFilter) : this.identityStorage.getIdentitiesByProfileFilterCount(this.providerId, this.profileFilter);
        return size;
    }

    public static enum Type {
        ALL,
        BY_FIRST_CHARACTER_OF_NAME,
        MENTION,
        UNIFIED_SEARCH;

    }
}

