/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class SocialUserEventListenerImpl
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(SocialUserEventListenerImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSave(User user, boolean isNew) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityStorage ids = (IdentityStorage)container.getComponentInstanceOfType(IdentityStorage.class);
            Identity identity = ids.findIdentity("organization", user.getUserName());
            if (isNew && identity != null && identity.isDeleted()) {
                throw new RuntimeException("Unable to create a previously deleted user : " + user.getUserName());
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(User user, boolean isNew) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            Identity identity = idm.getOrCreateIdentity("organization", user.getUserName(), true);
            Profile profile = identity.getProfile();
            boolean hasUpdated = false;
            if (!isNew) {
                String uFirstName = user.getFirstName();
                String uLastName = user.getLastName();
                String uDisplayName = user.getDisplayName();
                String uEmail = user.getEmail();
                String pFirstName = (String)profile.getProperty("firstName");
                String pLastName = (String)profile.getProperty("lastName");
                String pFullName = (String)profile.getProperty("fullName");
                String pEmail = (String)profile.getProperty("email");
                if (pFirstName == null || !pFirstName.equals(uFirstName)) {
                    profile.setProperty("firstName", uFirstName);
                    hasUpdated = true;
                }
                if (pLastName == null || !pLastName.equals(uLastName)) {
                    profile.setProperty("lastName", uLastName);
                    hasUpdated = true;
                }
                if (uDisplayName == null || StringUtils.isEmpty((String)uDisplayName)) {
                    uDisplayName = uFirstName + " " + uLastName;
                }
                if (!uDisplayName.equals(pFullName)) {
                    profile.setProperty("fullName", uDisplayName);
                }
                if (pEmail == null || !pEmail.equals(uEmail)) {
                    profile.setProperty("email", uEmail);
                    hasUpdated = true;
                }
            }
            if (hasUpdated) {
                profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
            } else {
                profile.setListUpdateTypes(new ArrayList<Profile.UpdateType>());
            }
            idm.updateProfile(profile);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDelete(User user) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            Identity identity = idm.getOrCreateIdentity("organization", user.getUserName(), true);
            try {
                idm.hardDeleteIdentity(identity);
            }
            catch (Exception e) {
                LOG.warn((Object)("Problem occurred when deleting user named " + identity.getRemoteId()), (Throwable)e);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

