/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.util.ImageIOUtil;
import org.apache.pdfbox.util.PDFStreamEngine;

public class PDFImageWriter
extends PDFStreamEngine {
    public PDFImageWriter() {
    }

    public PDFImageWriter(Properties props) throws IOException {
        super(props);
    }

    public boolean writeImage(PDDocument document, String imageType, String password, int startPage, int endPage, String outputPrefix) throws IOException {
        int resolution;
        try {
            resolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException e) {
            resolution = 96;
        }
        return this.writeImage(document, imageType, password, startPage, endPage, outputPrefix, 8, resolution);
    }

    public boolean writeImage(PDDocument document, String imageFormat, String password, int startPage, int endPage, String outputPrefix, int imageType, int resolution) throws IOException {
        boolean bSuccess = true;
        List pages = document.getDocumentCatalog().getAllPages();
        for (int i = startPage - 1; i < endPage && i < pages.size(); ++i) {
            PDPage page = (PDPage)pages.get(i);
            BufferedImage image = page.convertToImage(imageType, resolution);
            String fileName = outputPrefix + (i + 1);
            System.out.println("Writing: " + fileName + "." + imageFormat);
            bSuccess &= ImageIOUtil.writeImage(image, imageFormat, fileName, imageType, resolution);
        }
        return bSuccess;
    }
}

