/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.bio.util;

import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.transport.bio.util.LinkObject;
import org.apache.catalina.tribes.transport.bio.util.SingleRemoveSynchronizedAddLock;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class FastQueue {
    private static final Log log = LogFactory.getLog(FastQueue.class);
    private SingleRemoveSynchronizedAddLock lock = new SingleRemoveSynchronizedAddLock();
    private LinkObject first = null;
    private LinkObject last = null;
    private volatile int size = 0;
    private volatile boolean checkLock = false;
    private volatile boolean inAdd = false;
    private volatile boolean inRemove = false;
    private volatile boolean inMutex = false;
    private int maxQueueLength = 0;
    private long addWaitTimeout = 10000L;
    private long removeWaitTimeout = 30000L;
    private volatile boolean enabled = true;
    private int maxSize = 0;

    public FastQueue() {
        this.lock.setAddWaitTimeout(this.addWaitTimeout);
        this.lock.setRemoveWaitTimeout(this.removeWaitTimeout);
    }

    public long getAddWaitTimeout() {
        this.addWaitTimeout = this.lock.getAddWaitTimeout();
        return this.addWaitTimeout;
    }

    public void setAddWaitTimeout(long timeout) {
        this.addWaitTimeout = timeout;
        this.lock.setAddWaitTimeout(this.addWaitTimeout);
    }

    public long getRemoveWaitTimeout() {
        this.removeWaitTimeout = this.lock.getRemoveWaitTimeout();
        return this.removeWaitTimeout;
    }

    public void setRemoveWaitTimeout(long timeout) {
        this.removeWaitTimeout = timeout;
        this.lock.setRemoveWaitTimeout(this.removeWaitTimeout);
    }

    public int getMaxQueueLength() {
        return this.maxQueueLength;
    }

    public void setMaxQueueLength(int length) {
        this.maxQueueLength = length;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        if (!enable) {
            this.lock.abortRemove();
            this.first = null;
            this.last = null;
        }
    }

    public boolean isCheckLock() {
        return this.checkLock;
    }

    public void setCheckLock(boolean checkLock) {
        this.checkLock = checkLock;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public void unlockAdd() {
        this.lock.unlockAdd(this.size > 0);
    }

    public void unlockRemove() {
        this.lock.unlockRemove();
    }

    public void start() {
        this.setEnabled(true);
    }

    public void stop() {
        this.setEnabled(false);
    }

    public int getSize() {
        return this.size;
    }

    public SingleRemoveSynchronizedAddLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ChannelMessage msg, Member[] destination, InterceptorPayload payload) {
        boolean ok = true;
        if (!this.enabled) {
            if (log.isInfoEnabled()) {
                log.info((Object)"FastQueue.add: queue disabled, add aborted");
            }
            return false;
        }
        this.lock.lockAdd();
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.add: starting with size " + this.size));
            }
            if (this.checkLock) {
                if (this.inAdd) {
                    log.warn((Object)"FastQueue.add: Detected other add");
                }
                this.inAdd = true;
                if (this.inMutex) {
                    log.warn((Object)"FastQueue.add: Detected other mutex in add");
                }
                this.inMutex = true;
            }
            if (this.maxQueueLength > 0 && this.size >= this.maxQueueLength) {
                ok = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("FastQueue.add: Could not add, since queue is full (" + this.size + ">=" + this.maxQueueLength + ")"));
                }
            } else {
                LinkObject element = new LinkObject(msg, destination, payload);
                if (this.size == 0) {
                    this.first = this.last = element;
                    this.size = 1;
                } else if (this.last == null) {
                    ok = false;
                    log.error((Object)("FastQueue.add: Could not add, since last is null although size is " + this.size + " (>0)"));
                } else {
                    this.last.append(element);
                    this.last = element;
                    ++this.size;
                }
            }
            if (this.first == null) {
                log.error((Object)("FastQueue.add: first is null, size is " + this.size + " at end of add"));
            }
            if (this.last == null) {
                log.error((Object)("FastQueue.add: last is null, size is " + this.size + " at end of add"));
            }
            if (this.checkLock) {
                if (!this.inMutex) {
                    log.warn((Object)"FastQueue.add: Cancelled by other mutex in add");
                }
                this.inMutex = false;
                if (!this.inAdd) {
                    log.warn((Object)"FastQueue.add: Cancelled by other add");
                }
                this.inAdd = false;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.add: add ending with size " + this.size));
            }
        }
        finally {
            this.lock.unlockAdd(true);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkObject remove() {
        LinkObject element;
        if (!this.enabled) {
            if (log.isInfoEnabled()) {
                log.info((Object)"FastQueue.remove: queue disabled, remove aborted");
            }
            return null;
        }
        boolean gotLock = this.lock.lockRemove();
        try {
            if (!gotLock) {
                if (this.enabled) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"FastQueue.remove: Remove aborted although queue enabled");
                    }
                } else if (log.isInfoEnabled()) {
                    log.info((Object)"FastQueue.remove: queue disabled, remove aborted");
                }
                LinkObject linkObject = null;
                return linkObject;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.remove: remove starting with size " + this.size));
            }
            if (this.checkLock) {
                if (this.inRemove) {
                    log.warn((Object)"FastQueue.remove: Detected other remove");
                }
                this.inRemove = true;
                if (this.inMutex) {
                    log.warn((Object)"FastQueue.remove: Detected other mutex in remove");
                }
                this.inMutex = true;
            }
            element = this.first;
            this.last = null;
            this.first = null;
            this.size = 0;
            if (this.checkLock) {
                if (!this.inMutex) {
                    log.warn((Object)"FastQueue.remove: Cancelled by other mutex in remove");
                }
                this.inMutex = false;
                if (!this.inRemove) {
                    log.warn((Object)"FastQueue.remove: Cancelled by other remove");
                }
                this.inRemove = false;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.remove: remove ending with size " + this.size));
            }
        }
        finally {
            this.lock.unlockRemove();
        }
        return element;
    }
}

