/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PCVPortletUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)PCVPortletUpgradePlugin.class.getName());
    private RepositoryService repoService;

    public PCVPortletUpgradePlugin(RepositoryService repoService, InitParams initParams) {
        super(initParams);
        this.repoService = repoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        SessionProvider sessionProvider = null;
        try {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession("portal-system", this.repoService.getCurrentRepository());
            NodeIterator iter = session.getWorkspace().getQueryManager().createQuery("Select * from mop:workspaceclone where mop:contentid='presentation/ParameterizedContentViewerPortlet' ", "sql").execute().getNodes();
            while (iter.hasNext()) {
                try {
                    Value[] value;
                    Node contextEnable;
                    Node node = iter.nextNode();
                    if (!node.hasProperty("mop:contentid")) continue;
                    node.setProperty("mop:contentid", "presentation/SingleContentViewer");
                    if (!node.hasNode("mop:state")) continue;
                    Node mopState = node.getNode("mop:state");
                    if (!mopState.hasNode("ContextEnable")) {
                        contextEnable = mopState.addNode("ContextEnable", "mop:portletpreference");
                        contextEnable.setProperty("mop:readonly", false);
                        value = new Value[]{session.getValueFactory().createValue("true")};
                        contextEnable.setProperty("mop:value", value);
                    }
                    if (!mopState.hasNode("mop:ParameterName")) {
                        contextEnable = mopState.addNode("mop:ParameterName", "mop:portletpreference");
                        contextEnable.setProperty("mop:readonly", false);
                        value = new Value[]{session.getValueFactory().createValue("content-id")};
                        contextEnable.setProperty("mop:value", value);
                    }
                    node.save();
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)("Migrate node: " + node.getPath()));
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)"An unexpected error occurs when modifying PCV portlets: ", (Throwable)e);
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(((Object)((Object)this)).getClass().getName() + " finished successfully!"));
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An unexpected error occurs when modifying PCV portlets: ", (Throwable)e);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

