/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.html;

import java.util.Map;
import org.xwiki.rendering.internal.renderer.xhtml.XHTMLChainingRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkRenderer;
import org.xwiki.rendering.listener.chaining.ListenerChain;

public class HTMLMacroXHTMLChainingRenderer
extends XHTMLChainingRenderer {
    public HTMLMacroXHTMLChainingRenderer(XHTMLLinkRenderer linkRenderer, XHTMLImageRenderer imageRenderer, ListenerChain listenerChain) {
        super(linkRenderer, imageRenderer, listenerChain);
    }

    private boolean isInGeneratedBlock() {
        return this.getBlockState().isInMacro();
    }

    public void onSpecialSymbol(char symbol) {
        if (!this.isInGeneratedBlock()) {
            this.getPrinter().print("" + symbol);
        } else {
            super.onSpecialSymbol(symbol);
        }
    }

    public void onWord(String word) {
        if (!this.isInGeneratedBlock()) {
            this.getPrinter().print(word);
        } else {
            super.onWord(word);
        }
    }

    public void onNewLine() {
        if (!this.isInGeneratedBlock()) {
            this.getPrinter().print("\n");
        } else {
            super.onNewLine();
        }
    }

    public void onSpace() {
        if (!this.isInGeneratedBlock()) {
            this.getPrinter().print(" ");
        } else {
            super.onSpace();
        }
    }

    public void onEmptyLines(int count) {
        if (this.isInGeneratedBlock()) {
            super.onEmptyLines(count);
        }
    }

    public void beginParagraph(Map<String, String> parameters) {
        if (this.isInGeneratedBlock()) {
            super.beginParagraph(parameters);
        }
    }

    public void endParagraph(Map<String, String> parameters) {
        if (this.isInGeneratedBlock()) {
            super.endParagraph(parameters);
        }
    }

    public void onMacro(String id, Map<String, String> parameters, String content, boolean isInline) {
    }

    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
    }

    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
    }
}

