/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeForm;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeManager;
import org.exoplatform.ecm.webui.core.UIPagingGridDecorator;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInputInfo;

@ComponentConfig(template="app:/groovy/webui/component/admin/nodetype/UINodeTypeList.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UINodeTypeList.msg.confirm-delete"), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={ExportActionListener.class})})
public class UINodeTypeList
extends UIPagingGridDecorator {
    public static final String DRAFTNODETYPE = "jcr:system/jcr:nodetypesDraft";
    public static final String[] ACTIONS = new String[]{"Add", "Import", "Export"};
    public static final String[] CANCEL = new String[]{"Cancel"};
    public static final String[] TAB_REMOVE = new String[]{"superTypeTab", "DefaultTypeTab", "RequiredTypeTab"};

    public UINodeTypeList() throws Exception {
        this.getUIPageIterator().setId("UINodeTypeListIterator");
    }

    public List getAllNodeTypes() throws Exception {
        ArrayList<NodeTypeBean> nodeList = new ArrayList<NodeTypeBean>();
        ManageableRepository mRepository = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        ExtendedNodeTypeManager ntManager = mRepository.getNodeTypeManager();
        NodeTypeIterator nodeTypeIter = ntManager.getAllNodeTypes();
        while (nodeTypeIter.hasNext()) {
            nodeList.add(new NodeTypeBean(nodeTypeIter.nextNodeType()));
        }
        Collections.sort(nodeList, new NodeTypeNameComparator());
        Session session = mRepository.getSystemSession(mRepository.getConfiguration().getSystemWorkspaceName());
        if (session.getRootNode().hasNode(DRAFTNODETYPE)) {
            Node draftNode = session.getRootNode().getNode(DRAFTNODETYPE);
            NodeIterator nodeIter = draftNode.getNodes();
            while (nodeIter.hasNext()) {
                nodeList.add((NodeTypeBean)nodeIter.nextNode());
            }
        }
        session.logout();
        return nodeList;
    }

    public List getNodeTypeList() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.getUIPageIterator().getCurrentPageData());
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void refresh(String name, int currentPage, List<NodeTypeBean> nodeType) throws Exception {
        ListAccessImpl nodeTypeList = new ListAccessImpl(Object.class, NodeLocation.getLocationsByNodeList(nodeType));
        LazyPageList pageList = new LazyPageList((ListAccess)nodeTypeList, this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setPageList((PageList)pageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public void refresh(String name, int currentPage) throws Exception {
        ManageableRepository manaRepository = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        Session session = manaRepository.getSystemSession(manaRepository.getConfiguration().getSystemWorkspaceName());
        if (name != null) {
            if (session.getRootNode().hasNode(DRAFTNODETYPE)) {
                Node draftNode = session.getRootNode().getNode(DRAFTNODETYPE);
                if (draftNode.hasNode(name)) {
                    Node deleteNode = draftNode.getNode(name);
                    deleteNode.remove();
                    draftNode.save();
                }
                if (!draftNode.hasNodes()) {
                    draftNode.remove();
                }
                session.save();
            }
        } else {
            session.refresh(true);
        }
        session.logout();
        this.refresh(name, currentPage, this.getAllNodeTypes());
    }

    public void refresh(int currentPage) throws Exception {
        this.refresh(null, currentPage);
    }

    public static class NodeTypeNameComparator
    implements Comparator<NodeTypeBean> {
        @Override
        public int compare(NodeTypeBean n1, NodeTypeBean n2) throws ClassCastException {
            String name1 = n1.getName();
            String name2 = n2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }

    public static class NodeTypeBean {
        private String nodeTypeName_;
        private boolean isMixin_;
        private boolean hasOrderableChildNodes_;

        public NodeTypeBean(NodeType nodeType) {
            this.nodeTypeName_ = nodeType.getName();
            this.isMixin_ = nodeType.isMixin();
            this.hasOrderableChildNodes_ = nodeType.hasOrderableChildNodes();
        }

        public String getName() {
            return this.nodeTypeName_;
        }

        public void setName(String nodeTypeName) {
            this.nodeTypeName_ = nodeTypeName;
        }

        public boolean isMixin() {
            return this.isMixin_;
        }

        public void setMixin(boolean isMixin) {
            this.isMixin_ = isMixin;
        }

        public boolean hasOrderableChildNodes() {
            return this.hasOrderableChildNodes_;
        }

        public void setOrderableChildNodes(boolean value) {
            this.hasOrderableChildNodes_ = value;
        }
    }

    public static class DeleteActionListener
    extends EventListener<UINodeTypeList> {
        public void execute(Event<UINodeTypeList> event) throws Exception {
            UINodeTypeList uiNodeList = (UINodeTypeList)((Object)event.getSource());
            ManageableRepository manaRepository = ((RepositoryService)uiNodeList.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
            Session session = manaRepository.getSystemSession(manaRepository.getConfiguration().getSystemWorkspaceName());
            String nodeName = event.getRequestContext().getRequestParameter("objectId");
            if (session.getRootNode().hasNode(UINodeTypeList.DRAFTNODETYPE)) {
                Node draftNode = session.getRootNode().getNode(UINodeTypeList.DRAFTNODETYPE);
                Node deleteNode = draftNode.getNode(nodeName);
                deleteNode.remove();
                draftNode.save();
                if (!draftNode.hasNodes()) {
                    draftNode.remove();
                }
                session.save();
                uiNodeList.refresh(null, uiNodeList.getUIPageIterator().getCurrentPage());
                event.getRequestContext().addUIComponentToUpdateByAjax(uiNodeList.getParent());
            }
            session.logout();
        }
    }

    public static class EditActionListener
    extends EventListener<UINodeTypeList> {
        public void execute(Event<UINodeTypeList> event) throws Exception {
            UINodeTypeList uiNodeList = (UINodeTypeList)((Object)event.getSource());
            ManageableRepository manaRepository = ((RepositoryService)uiNodeList.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
            Session session = manaRepository.getSystemSession(manaRepository.getConfiguration().getSystemWorkspaceName());
            String nodeName = event.getRequestContext().getRequestParameter("objectId");
            Node draftNodeType = session.getRootNode().getNode("jcr:system/jcr:nodetypesDraft/" + nodeName);
            UINodeTypeManager uiManager = (UINodeTypeManager)uiNodeList.getParent();
            uiManager.initPopup(false);
            UINodeTypeForm uiForm = (UINodeTypeForm)uiManager.findFirstComponentOfType(UINodeTypeForm.class);
            uiForm.refresh();
            uiForm.removeChildTabs(TAB_REMOVE);
            uiForm.updateEdit(draftNodeType, true);
            UIFormInputSetWithAction tab = (UIFormInputSetWithAction)uiForm.getChildById("nodeTypeDefinition");
            String[] actionNames = new String[]{"Save", "SaveDraft", "Cancel"};
            tab.setActions(actionNames, null);
            tab.setIsView(false);
            uiForm.setTabRender("nodeTypeDefinition");
            session.logout();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class ViewActionListener
    extends EventListener<UINodeTypeList> {
        public void execute(Event<UINodeTypeList> event) throws Exception {
            UINodeTypeList uiList = (UINodeTypeList)((Object)event.getSource());
            String ntName = event.getRequestContext().getRequestParameter("objectId");
            ManageableRepository manaRepository = ((RepositoryService)uiList.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
            Session session = manaRepository.getSystemSession(manaRepository.getConfiguration().getSystemWorkspaceName());
            NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
            NodeType nodeType = ntManager.getNodeType(ntName);
            UINodeTypeManager uiManager = (UINodeTypeManager)uiList.getParent();
            uiManager.initPopup(true);
            UINodeTypeForm uiForm = (UINodeTypeForm)uiManager.findFirstComponentOfType(UINodeTypeForm.class);
            uiForm.update(nodeType, true);
            for (UIComponent uiComp : uiForm.getChildren()) {
                UIFormInputSetWithAction tab = (UIFormInputSetWithAction)uiForm.getChildById(uiComp.getId());
                for (UIComponent uiChild : tab.getChildren()) {
                    if (uiChild instanceof UIFormInputInfo) continue;
                    tab.setActionInfo(uiChild.getName(), null);
                }
                if (tab.getId().equals("nodeTypeDefinition")) {
                    tab.setRendered(true);
                    tab.setActions(new String[]{"Close"}, null);
                    continue;
                }
                tab.setRendered(true);
                tab.setActions(null, null);
            }
            uiForm.removeChildTabs(TAB_REMOVE);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class ExportActionListener
    extends EventListener<UINodeTypeList> {
        public void execute(Event<UINodeTypeList> event) throws Exception {
            UINodeTypeList uiList = (UINodeTypeList)((Object)event.getSource());
            UINodeTypeManager uiManager = (UINodeTypeManager)uiList.getParent();
            uiManager.setExportPopup();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class ImportActionListener
    extends EventListener<UINodeTypeList> {
        public void execute(Event<UINodeTypeList> event) throws Exception {
            UINodeTypeList uiList = (UINodeTypeList)((Object)event.getSource());
            UINodeTypeManager uiManager = (UINodeTypeManager)uiList.getParent();
            uiManager.setImportPopup();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class AddActionListener
    extends EventListener<UINodeTypeList> {
        public void execute(Event<UINodeTypeList> event) throws Exception {
            UINodeTypeList uiList = (UINodeTypeList)((Object)event.getSource());
            UINodeTypeManager uiManager = (UINodeTypeManager)uiList.getParent();
            uiManager.initPopup(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

