/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.chromattic.entity;

import java.util.List;
import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.social.core.chromattic.entity.ActivityEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityYearEntity;

@PrimaryType(name="soc:activitylist", orderable=true)
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="soc")
public abstract class ActivityListEntity {
    @Path
    public abstract String getPath();

    @Property(name="soc:number")
    @DefaultValue(value={"0"})
    public abstract Integer getNumber();

    public abstract void setNumber(Integer var1);

    @OneToMany
    public abstract Map<String, ActivityYearEntity> getYears();

    @OneToMany
    public abstract List<ActivityYearEntity> getYearsList();

    @Create
    public abstract ActivityYearEntity newYear();

    @Create
    public abstract ActivityEntity createActivity(String var1);

    public void inc() {
        this.setNumber(this.getNumber() + 1);
    }

    public void desc() {
        this.setNumber(this.getNumber() - 1);
    }

    public ActivityYearEntity getYear(String year) {
        ActivityYearEntity yearEntity = this.getYears().get(year);
        if (yearEntity == null) {
            yearEntity = this.newYear();
            this.getYears().put(year, yearEntity);
            this.getYearsList().add(yearEntity);
        }
        return yearEntity;
    }
}

