/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.info;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.core.UIPermissionManagerBase;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.organization.UIGroupMembershipSelector;

@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/webui/component/explorer/popup/info/UIGroupSelector.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={SelectMembershipActionListener.class}), @EventConfig(listeners={SelectPathActionListener.class})}), @ComponentConfig(type=UITree.class, id="UITreeGroupSelector", template="system:/groovy/webui/core/UITree.gtmpl", events={@EventConfig(listeners={UITree.ChangeNodeActionListener.class})}), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbGroupSelector", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={UIBreadcumbs.SelectPathActionListener.class})})})
public class UIGroupSelector
extends UIGroupMembershipSelector
implements ComponentSelector {
    private UIComponent uiComponent;
    private String returnFieldName = null;
    private boolean isSelectGroup_ = false;
    private boolean isSelectMember_ = false;
    private boolean isSelectUSer_ = false;

    public UIComponent getSourceComponent() {
        return this.uiComponent;
    }

    public String getReturnField() {
        return this.returnFieldName;
    }

    public void setSourceComponent(UIComponent uicomponent, String[] initParams) {
        this.uiComponent = uicomponent;
        if (initParams == null || initParams.length < 0) {
            return;
        }
        for (int i = 0; i < initParams.length; ++i) {
            if (initParams[i].indexOf("returnField") > -1) {
                String[] array = initParams[i].split("=");
                this.returnFieldName = array[1];
                break;
            }
            this.returnFieldName = initParams[0];
        }
    }

    public void setSelectGroup(boolean isSelect) {
        this.isSelectGroup_ = isSelect;
    }

    public void setSelectMember(boolean isSelect) {
        this.isSelectMember_ = isSelect;
    }

    public void setSelectUser(boolean isSelect) {
        this.isSelectUSer_ = isSelect;
    }

    public boolean isSelectGroup() {
        return this.isSelectGroup_;
    }

    public boolean isSelectMember() {
        return this.isSelectMember_;
    }

    public boolean isSelectUser() {
        return this.isSelectUSer_;
    }

    private void setDefaultValue() {
        this.isSelectGroup_ = false;
        this.isSelectMember_ = false;
        this.isSelectUSer_ = false;
    }

    public List getChildGroup() throws Exception {
        ArrayList<Group> children = new ArrayList<Group>();
        OrganizationService service = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
        for (Object child : service.getGroupHandler().findGroups(this.getCurrentGroup())) {
            children.add((Group)child);
        }
        return children;
    }

    public List<User> getUsers() throws Exception {
        ArrayList<User> children = new ArrayList<User>();
        OrganizationService service = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
        ListAccess userPageList = service.getUserHandler().findUsersByGroupId(this.getCurrentGroup().getId());
        for (User child : (User[])userPageList.load(0, userPageList.getSize())) {
            children.add(child);
        }
        return children;
    }

    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)event.getSource();
            UIGroupSelector uiGroupSelector = (UIGroupSelector)uiBreadcumbs.getParent();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiBreadcumbs.setSelectPath(objectId);
            String selectGroupId = uiBreadcumbs.getSelectLocalPath().getId();
            uiGroupSelector.changeGroup(selectGroupId);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiGroupSelector);
        }
    }

    public static class ChangeNodeActionListener
    extends EventListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            UIGroupSelector uiGroupSelector = (UIGroupSelector)((UITree)event.getSource()).getAncestorOfType(UIGroupSelector.class);
            String groupId = event.getRequestContext().getRequestParameter("objectId");
            uiGroupSelector.changeGroup(groupId);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiGroupSelector);
        }
    }

    public static class SelectMembershipActionListener
    extends EventListener<UIGroupSelector> {
        public void execute(Event<UIGroupSelector> event) throws Exception {
            UIJCRExplorer uiExplorer;
            Node node;
            UIGroupSelector uiGroupSelector = (UIGroupSelector)((Object)event.getSource());
            String user = event.getRequestContext().getRequestParameter("objectId");
            if (user.equals(Utils.getNodeOwner((Node)(node = (uiExplorer = (UIJCRExplorer)uiGroupSelector.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode())))) {
                UIApplication uiApp = (UIApplication)uiGroupSelector.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIGroupSelector.msg.not-change-owner", new Object[]{user}));
                return;
            }
            String returnField = uiGroupSelector.getReturnField();
            ((UISelectable)uiGroupSelector.getSourceComponent()).doSelect(returnField, (Object)user);
            UIPopupWindow uiPopup = (UIPopupWindow)uiGroupSelector.getParent();
            uiGroupSelector.setDefaultValue();
            uiPopup.setShow(false);
            UIPermissionManagerBase uiManager = (UIPermissionManagerBase)uiGroupSelector.getAncestorOfType(UIPermissionManagerBase.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

