/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.lock.SessionLockManager;
import org.exoplatform.services.security.IdentityConstants;

public abstract class AbstractSessionLockManager
implements SessionLockManager {
    protected final SessionDataManager transientManager;

    public AbstractSessionLockManager(SessionDataManager transientManager) {
        this.transientManager = transientManager;
    }

    protected abstract boolean isLockedPersisted(NodeData var1) throws LockException;

    protected abstract boolean isPersistedLockHolder(NodeData var1) throws RepositoryException;

    protected abstract boolean checkPersistedLocks(NodeData var1) throws LockException;

    public boolean checkLocking(NodeData data) throws LockException {
        while (this.transientManager.isNew(data.getIdentifier())) {
            try {
                if ((data = (NodeData)this.transientManager.getItemData(data.getParentIdentifier())) != null) continue;
                return true;
            }
            catch (RepositoryException e) {
                throw new LockException((Throwable)e);
            }
        }
        return this.checkPersistedLocks(data);
    }

    public boolean isLockHolder(NodeImpl node) throws RepositoryException {
        NodeData nodeData = (NodeData)node.getData();
        if (IdentityConstants.SYSTEM.equals(node.getSession().getUserID())) {
            return true;
        }
        if (this.transientManager.isNew(nodeData.getIdentifier()) && this.transientManager.isNew(nodeData.getParentIdentifier())) {
            return true;
        }
        return this.isPersistedLockHolder(nodeData);
    }

    public boolean isLocked(NodeData data) throws LockException {
        if (this.transientManager.isNew(data.getIdentifier())) {
            try {
                NodeData parentData = (NodeData)this.transientManager.getItemData(data.getParentIdentifier());
                if (parentData == null) {
                    return false;
                }
                return this.isLocked(parentData);
            }
            catch (RepositoryException e) {
                throw new LockException((Throwable)e);
            }
        }
        return this.isLockedPersisted(data);
    }
}

