/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.client.http;

import java.net.URL;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.exoplatform.container.client.http.HttpClientType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClientTypeMap {
    public static final String XHTML_MIME_TYPE = "text/xhtml";
    public static final String XHTMLMP_MIME_TYPE = "application/vnd.wap.xhtml+xml";
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ClientTypeMap");
    private ArrayList<HttpClientType> clientList_ = new ArrayList();
    private static volatile ClientTypeMap singleton_;

    private void loadClientsInfos() {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression clientTypeExp = xpath.compile("/clients-type/client-type");
            XPathExpression nameExp = xpath.compile("name/text()");
            XPathExpression userAgentPatternExp = xpath.compile("userAgentPattern/text()");
            XPathExpression preferredMimeTypeExp = xpath.compile("preferredMimeType/text()");
            XPathExpression rendererExp = xpath.compile("renderer/text()");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL url = cl.getResource("conf/portal/clients-type.xml");
            DocumentBuilderFactory finstance = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = finstance.newDocumentBuilder();
            Document document = builder.parse(url.openStream());
            NodeList nodes = (NodeList)clientTypeExp.evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = (String)nameExp.evaluate(node, XPathConstants.STRING);
                String userAgentPattern = (String)userAgentPatternExp.evaluate(node, XPathConstants.STRING);
                String preferredMimeType = (String)preferredMimeTypeExp.evaluate(node, XPathConstants.STRING);
                String renderer = (String)rendererExp.evaluate(node, XPathConstants.STRING);
                HttpClientType clientInfo = renderer != null && renderer.length() > 0 ? new HttpClientType(name, userAgentPattern, preferredMimeType, renderer) : new HttpClientType(name, userAgentPattern, preferredMimeType);
                this.addClientInfo(clientInfo);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    public ClientTypeMap() {
        this.loadClientsInfos();
    }

    protected void addClientInfo(HttpClientType clientInfo) {
        this.clientList_.add(clientInfo);
    }

    public HttpClientType findClient(String userAgent) {
        if (userAgent == null) {
            return this.clientList_.get(0);
        }
        if (userAgent.equals("")) {
            return this.clientList_.get(0);
        }
        for (int i = 0; i < this.clientList_.size(); ++i) {
            HttpClientType client = this.clientList_.get(i);
            String userAgentPattern = client.getUserAgentPattern();
            if (userAgentPattern == null) continue;
            try {
                if (!userAgent.matches(userAgentPattern)) continue;
                return client;
            }
            catch (PatternSyntaxException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return this.clientList_.get(0);
            }
        }
        return this.clientList_.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientTypeMap getInstance() {
        if (singleton_ != null) return singleton_;
        Class<ClientTypeMap> clazz = ClientTypeMap.class;
        synchronized (ClientTypeMap.class) {
            if (singleton_ != null) return singleton_;
            singleton_ = new ClientTypeMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton_;
        }
    }
}

