/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.service.ws;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollNodeTypes;
import org.exoplatform.poll.service.PollService;
import org.exoplatform.poll.service.PollSummary;
import org.exoplatform.poll.service.Utils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;

@Path(value="ks/poll")
public class PollWebservice
implements ResourceContainer {
    private static final Log log = ExoLogger.getLogger(PollWebservice.class);
    public static final String APP_TYPE = "poll".intern();
    private OrganizationService organizationService = null;
    private static final CacheControl cc;

    public PollWebservice() {
        this.getOrganizationService();
    }

    @GET
    @Path(value="/viewpoll/{resourceid}")
    @Produces(value={"application/json"})
    public Response viewPoll(@PathParam(value="resourceid") String pollId, @Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        String username;
        PollService pollService;
        block7: {
            pollService = (PollService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PollService.class);
            username = this.getUserId(sc, uriInfo);
            if (!Utils.isEmpty(pollId)) {
                try {
                    Poll poll = pollService.getPoll(pollId);
                    if (poll == null) break block7;
                    poll.setIsAdmin("true");
                    String group = poll.getParentPath();
                    boolean hasPerminsion = false;
                    if (group.indexOf(PollNodeTypes.APPLICATION_DATA) > 0 && poll.getIsAdmin().equals("false")) {
                        group = group.substring(group.indexOf(PollNodeTypes.GROUPS + "/") + PollNodeTypes.GROUPS.length(), group.indexOf("/" + PollNodeTypes.APPLICATION_DATA));
                        for (String group_ : this.getGroupsOfUser(username)) {
                            if (group_.indexOf(group) < 0) continue;
                            hasPerminsion = true;
                            break;
                        }
                    } else {
                        hasPerminsion = group.indexOf(PollNodeTypes.POLLS) < 0 ? pollService.hasPermissionInForum(group + "/" + poll.getId(), this.getAllGroupAndMembershipOfUser(username)) : true;
                    }
                    if (!hasPerminsion) {
                        poll = new Poll();
                        poll.setId("DoNotPermission");
                        return Response.ok((Object)poll, (String)"application/json").cacheControl(cc).build();
                    }
                    poll.setVotes();
                    poll.setInfoVote();
                    poll.setShowVote(this.isGuestPermission(poll, username));
                    return Response.ok((Object)poll, (String)"application/json").cacheControl(cc).build();
                }
                catch (Exception e) {
                    log.error((Object)("Can not get poll by id: " + pollId), (Throwable)e);
                }
            }
        }
        PollSummary pollSummary = new PollSummary();
        pollSummary = pollService.getPollSummary(this.getAllGroupAndMembershipOfUser(username));
        pollSummary.setIsAdmin("true");
        return Response.ok((Object)pollSummary, (String)"application/json").cacheControl(cc).build();
    }

    @GET
    @Path(value="/votepoll/{pollId}/{indexVote}")
    @Produces(value={"application/json"})
    public Response votePoll(@PathParam(value="pollId") String pollId, @PathParam(value="indexVote") String indexVote, @Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        if (!Utils.isEmpty(pollId) && !Utils.isEmpty(indexVote)) {
            try {
                PollService pollService = (PollService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PollService.class);
                Poll poll = pollService.getPoll(pollId.trim());
                String username = this.getUserId(sc, uriInfo);
                if (poll != null && !IdentityConstants.ANONIM.equals(username) && this.validateIndexVote(indexVote, poll.getOption().length)) {
                    poll = Utils.calculateVote(poll, username, indexVote);
                    pollService.savePoll(poll, false, true);
                    poll.setVotes();
                    poll.setInfoVote();
                    poll.setShowVote(this.isGuestPermission(poll, username));
                    poll.setIsAdmin(String.valueOf(this.hasGroupAdminOfGatein(username)));
                    return Response.ok((Object)poll, (String)"application/json").cacheControl(cc).build();
                }
            }
            catch (Exception e) {
                log.debug((Object)"Failed to vote poll.", (Throwable)e);
            }
            return Response.ok((Object)"You do not have permission to vote this poll; or some options have been removed from the poll.", (String)"text/plain").cacheControl(cc).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    private OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstance(OrganizationService.class);
        }
        return this.organizationService;
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        ConversationState state = ConversationState.getCurrent();
        if (state != null) {
            return state.getIdentity().getUserId();
        }
        if (sc != null && sc.getUserPrincipal() != null) {
            return sc.getUserPrincipal().getName();
        }
        if (uriInfo != null) {
            return this.getViewerId(uriInfo);
        }
        return "";
    }

    private String getViewerId(UriInfo uriInfo) {
        String[] queryParts;
        URI uri = uriInfo.getRequestUri();
        String requestString = uri.getQuery();
        if (requestString == null) {
            return null;
        }
        for (String queryPart : queryParts = requestString.split("&")) {
            if (!queryPart.startsWith("opensocial_viewer_id")) continue;
            return queryPart.substring(queryPart.indexOf("=") + 1, queryPart.length());
        }
        return null;
    }

    private boolean validateIndexVote(String indexVote, int max) {
        String[] ivArr = indexVote.split(Utils.COLON);
        for (int i = 1; i < ivArr.length; ++i) {
            try {
                int t = Integer.parseInt(ivArr[i]);
                if (t < max) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean isGuestPermission(Poll poll_, String username) throws Exception {
        String[] userVotes;
        Date today;
        if (poll_.getIsClosed()) {
            return true;
        }
        if (poll_.getTimeOut() > 0L && (today = Utils.getGreenwichMeanTime().getTime()).getTime() - poll_.getCreatedDate().getTime() >= poll_.getTimeOut() * 86400000L) {
            return true;
        }
        if (Utils.isEmpty(username) || IdentityConstants.ANONIM.equals(username)) {
            return true;
        }
        for (String string : userVotes = poll_.getUserVote()) {
            if (!(string = string.substring(0, string.indexOf(":"))).equalsIgnoreCase(username)) continue;
            return true;
        }
        return false;
    }

    private boolean hasGroupAdminOfGatein(String username) {
        try {
            UserACL userACL = (UserACL)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserACL.class);
            ArrayList<String> list = new ArrayList<String>();
            list.add(username);
            list.addAll(this.getGroupsOfUser(username));
            for (String str : list) {
                if (!str.equals(userACL.getSuperUser()) && !str.equals(userACL.getAdminGroups())) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to check has group admin of gatein." + e.getCause()));
        }
        return false;
    }

    private List<String> getAllGroupAndMembershipOfUser(String username) {
        ArrayList<String> listOfUser = new ArrayList<String>();
        try {
            listOfUser.add(username);
            HashSet list = new HashSet();
            Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUser(username);
            for (Membership membership : memberships) {
                listOfUser.add(membership.getGroupId());
                listOfUser.add(membership.getMembershipType() + ":" + membership.getGroupId());
            }
            listOfUser.addAll(list);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to get all info of user.");
        }
        return listOfUser;
    }

    private List<String> getGroupsOfUser(String username) {
        try {
            ArrayList<String> grIds = new ArrayList<String>();
            ConversationState state = ConversationState.getCurrent();
            if (state != null && username.equals(state.getIdentity().getUserId())) {
                Set groupsSet = state.getIdentity().getGroups();
                grIds.addAll(groupsSet);
            } else {
                for (Object gr : this.getOrganizationService().getGroupHandler().findGroupsOfUser(username)) {
                    grIds.add(((Group)gr).getId());
                }
            }
            return grIds;
        }
        catch (Exception e) {
            log.warn((Object)"Failed to get groupId of user.");
            return new ArrayList<String>();
        }
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

