/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class LiteralBox
extends AbstractBox {
    private static Logger LOG = Logger.getLogger(LiteralBox.class.getName());
    byte[] content;

    public LiteralBox(byte[] type) {
        super(type);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        if (size == -1L) {
            throw new IOException("box size of -1 is not supported. Boxsize -1 means box reaches until the end of the file.");
        }
        if ((long)((int)size) != size) {
            throw new IOException("The UnknownBox cannot be larger than 2^32 bytes(Plz enhance parser!!)");
        }
        this.content = in.read((int)size);
    }

    protected long getContentSize() {
        return this.content.length;
    }

    public String toString() {
        return "UnknownBox[type=" + IsoFile.bytesToFourCC(this.getType()) + ";contentLength=" + (this.content != null ? Integer.valueOf(this.content.length) : "?") + "]";
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.write(this.content);
    }

    public void setContent(byte[] content) {
        this.content = content;
    }
}

