/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.basemediaformat;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.h264.AvcConfigurationBox;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class AvcNalUnitStorageBox
extends AbstractBox {
    byte[] content;

    public AvcNalUnitStorageBox() {
        super(IsoFile.fourCCtoBytes("avcn"));
    }

    public AvcNalUnitStorageBox(AvcConfigurationBox avcConfigurationBox) {
        super(IsoFile.fourCCtoBytes("avcn"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            avcConfigurationBox.getBox(new IsoOutputStream(baos));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] header = avcConfigurationBox.getHeader();
        this.content = new byte[baos.size() - header.length];
        System.arraycopy(baos.toByteArray(), header.length, this.content, 0, this.content.length);
    }

    protected long getContentSize() {
        return this.content.length;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        if (size == -1L) {
            throw new IOException("box size of -1 is not supported. Boxsize -1 means box reaches until the end of the file.");
        }
        if ((long)((int)size) != size) {
            throw new IOException("The UnknownBox cannot be larger than 2^32 bytes(Plz enhance parser!!)");
        }
        this.content = in.read((int)size);
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.write(this.content);
    }
}

