/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.ancillary.servlet.Content;
import com.google.caja.ancillary.servlet.Job;
import com.google.caja.ancillary.servlet.Processor;
import com.google.caja.ancillary.servlet.Request;
import com.google.caja.ancillary.servlet.Verb;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.GuessContentType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import com.google.caja.util.Charsets;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Resources {
    Resources() {
    }

    static String readOptimized(Class<?> clazz, String resourcePath) {
        Job j;
        CharProducer cp = Resources.readRequired(clazz, resourcePath);
        ContentType t = GuessContentType.guess(null, resourcePath, cp);
        EchoingMessageQueue mq = new EchoingMessageQueue(new PrintWriter(System.err), new MessageContext(), true);
        URI base = cp.getCurrentPosition().source().getUri();
        Request req = Request.create(Verb.ECHO, null);
        req.otype = t;
        Processor p = new Processor(req, mq);
        try {
            j = p.parse(cp.clone(), t, null, base);
        }
        catch (ParseException ex) {
            ex.toMessageQueue(mq);
            return cp.toString();
        }
        try {
            Content c = p.reduce(p.process(Lists.newArrayList(j)));
            if (c.type == t) {
                return c.getText();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return cp.toString();
        }
        return cp.toString();
    }

    static CharProducer readRequired(Class<?> clazz, String resourcePath) {
        try {
            return Resources.read(clazz, resourcePath);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
    }

    static CharProducer read(Class<?> clazz, String resourcePath) throws IOException {
        URL src = clazz.getResource(resourcePath);
        if (src == null) {
            throw new FileNotFoundException(resourcePath);
        }
        InputStream in = clazz.getResourceAsStream(resourcePath);
        try {
            return CharProducer.Factory.create((Reader)new InputStreamReader(in, Charsets.UTF_8), new InputSource(src.toURI()));
        }
        catch (URISyntaxException ex) {
            throw (IOException)new IOException("Bad path " + resourcePath).initCause(ex);
        }
    }
}

