/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Chardet {
    private static final String UTF8 = "UTF-8";
    private static final String UTF16BE = "UTF-16BE";
    private static final String UTF16LE = "UTF-16LE";
    private static final String UTF32BE = "UTF-32BE";
    private static final String UTF32LE = "UTF-32LE";
    private static final String UTF7 = "UTF-7";
    private static final String UTF1 = "UTF-1";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final byte[] CHARSET_BYTES;
    private static final byte[] ENCODING_BYTES;
    private static final byte _00 = 0;
    private static final byte _2B = 43;
    private static final byte _2F = 47;
    private static final byte _38 = 56;
    private static final byte _39 = 57;
    private static final byte _4C = 76;
    private static final byte _64 = 100;
    private static final byte _76 = 118;
    private static final byte _BB = -69;
    private static final byte _BF = -65;
    private static final byte _EF = -17;
    private static final byte _F7 = -9;
    private static final byte _FE = -2;
    private static final byte _FF = -1;

    private Chardet() {
    }

    public static Pair<Reader, String> guessCharset(InputStream in) throws IOException {
        ByteArrayOutputStream buffered = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        boolean isAscii = true;
        int len = in.read(buf);
        if (len <= 0) {
            return Pair.pair(new StringReader(""), UTF8);
        }
        String charset = Chardet.findCharset(buf, len);
        if (charset != null) {
            buffered.write(buf, 0, len);
        } else if (Chardet.hasUtf8BOM(buf, len)) {
            charset = UTF8;
            buffered.write(buf, 3, len - 3);
        } else if (Chardet.hasUtf32BEBOM(buf, len)) {
            charset = UTF32BE;
            buffered.write(buf, 4, len - 4);
        } else if (Chardet.hasUtf32LEBOM(buf, len)) {
            charset = UTF32LE;
            buffered.write(buf, 4, len - 4);
        } else if (Chardet.hasUtf16BEBOM(buf, len)) {
            charset = UTF16BE;
            buffered.write(buf, 2, len - 2);
        } else if (Chardet.hasUtf16LEBOM(buf, len)) {
            charset = UTF16LE;
            buffered.write(buf, 2, len - 2);
        } else if (Chardet.hasUtf7BOM(buf, len)) {
            charset = UTF7;
            buffered.write(buf, 4, len - 4);
        } else if (Chardet.hasUtf1BOM(buf, len)) {
            charset = UTF1;
            buffered.write(buf, 3, len - 3);
        } else {
            nsDetector det = new nsDetector(0);
            class Observer
            implements nsICharsetDetectionObserver {
                String charset;

                Observer() {
                }

                public void Notify(String charset) {
                    this.charset = charset;
                }
            }
            Observer observer = new Observer();
            det.Init((nsICharsetDetectionObserver)observer);
            do {
                buffered.write(buf, 0, len);
                if (!isAscii) continue;
                isAscii = det.isAscii(buf, len);
            } while ((isAscii || !det.DoIt(buf, len, false)) && (len = in.read(buf)) > 0);
            det.DataEnd();
            charset = observer.charset;
        }
        if (charset != null) {
            charset = Chardet.supportedCharsetName(charset);
        }
        if (charset == null) {
            charset = UTF8;
        }
        return Pair.pair(Chardet.joinStreamsWithCharset(buffered.toByteArray(), in, charset), charset);
    }

    private static String findCharset(byte[] buf, int len) {
        block0: for (int i = 0; i < len; ++i) {
            if (60 != buf[i]) continue;
            byte lastByte = 60;
            byte[] attrBytes = CHARSET_BYTES;
            int n = len;
            for (int j = i + 1; j < n; ++j) {
                byte b = buf[j];
                if (b == 0) continue;
                if (b == 63 && lastByte == 60) {
                    attrBytes = ENCODING_BYTES;
                }
                if ((b | 0x20) == attrBytes[0] && !Chardet.isAlnum(lastByte)) {
                    int wordLen = attrBytes.length;
                    int pos = j + 1;
                    int k = 1;
                    while (pos < n && k < wordLen) {
                        b = buf[pos];
                        if (b == 0 || b == 45) {
                            ++pos;
                            continue;
                        }
                        if ((b | 0x20) != attrBytes[k]) break;
                        ++k;
                        ++pos;
                    }
                    if (k == wordLen) {
                        block3: while (pos < len) {
                            b = buf[pos];
                            if (b == 61) {
                                while (++pos < len) {
                                    int start;
                                    b = buf[pos];
                                    if (b == 0 || Chardet.isSpace(b)) continue;
                                    if (b == 34 || b == 39) {
                                        start = pos + 1;
                                    } else {
                                        if (!Chardet.isAlnum(b)) break block3;
                                        start = pos;
                                    }
                                    int end = start;
                                    boolean sawLetter = false;
                                    while (end < len) {
                                        b = buf[end];
                                        if (b == 0 || b == 45 || b == 95) {
                                            ++end;
                                            continue;
                                        }
                                        if (!Chardet.isAlnum(b)) break;
                                        sawLetter = true;
                                        ++end;
                                    }
                                    if (!sawLetter) continue;
                                    StringBuilder sb = new StringBuilder(end - start);
                                    for (int bi = start; bi < end; ++bi) {
                                        if (buf[bi] == 0) continue;
                                        sb.append((char)buf[bi]);
                                    }
                                    String charset = Chardet.supportedCharsetName(sb.toString());
                                    if (charset == null) continue;
                                    return charset;
                                }
                                break;
                            }
                            if (b != 0 && !Chardet.isSpace(b)) break;
                            ++pos;
                        }
                    }
                    if (b == 60 || b == 62) {
                        i = pos - 1;
                        continue block0;
                    }
                } else if (b == 60 || b == 62) {
                    i = j - 1;
                    continue block0;
                }
                lastByte = buf[j];
            }
        }
        return null;
    }

    private static Reader joinStreamsWithCharset(byte[] buffered, InputStream tail, String charset) throws IOException {
        class JoinedStream
        extends InputStream {
            byte[] buffered;
            int pos;
            final InputStream tail;

            JoinedStream(byte[] buffered, InputStream tail) {
                this.buffered = buffered;
                this.tail = tail;
            }

            public int read() throws IOException {
                if (this.buffered != null) {
                    if (this.pos < this.buffered.length) {
                        return this.buffered[this.pos++];
                    }
                    this.buffered = null;
                }
                return this.tail.read();
            }

            public int read(byte[] out, int off, int len) throws IOException {
                int nRead = 0;
                if (this.buffered != null) {
                    int avail = this.buffered.length - this.pos;
                    if (avail != 0) {
                        int k = Math.min(len, avail);
                        int p1 = this.pos + k;
                        int p2 = off + k;
                        this.pos = p1;
                        while (--p2 >= off) {
                            out[p2] = this.buffered[--p1];
                        }
                        off += k;
                        len -= k;
                        nRead = k;
                    } else {
                        this.buffered = null;
                    }
                }
                if (len == 0) {
                    return nRead;
                }
                int nFromTail = this.tail.read(out, off, len);
                if (nFromTail > 0) {
                    return nFromTail + nRead;
                }
                return nRead != 0 ? nRead : -1;
            }

            public void close() throws IOException {
                this.buffered = null;
                this.tail.close();
            }
        }
        return new InputStreamReader((InputStream)new JoinedStream(buffered, tail), charset);
    }

    private static boolean isAlnum(byte b) {
        if (b < 48 || b > 122) {
            return false;
        }
        if (b < 65) {
            return b <= 57;
        }
        return b >= 97 || b <= 90;
    }

    private static boolean isSpace(byte b) {
        return b <= 32 && (b == 32 || b == 13 || b == 10 || b == 9 || b == 12);
    }

    static String supportedCharsetName(String s) {
        try {
            return Charset.forName(s).name();
        }
        catch (UnsupportedCharsetException ex) {
            return null;
        }
        catch (IllegalCharsetNameException ex) {
            return null;
        }
    }

    private static boolean hasUtf8BOM(byte[] b, int len) {
        return len >= 3 && b[0] == -17 && b[1] == -69 && b[2] == -65;
    }

    private static boolean hasUtf16BEBOM(byte[] b, int len) {
        return len >= 2 && b[0] == -2 && b[1] == -1;
    }

    private static boolean hasUtf16LEBOM(byte[] b, int len) {
        return len >= 2 && b[0] == -1 && b[1] == -2;
    }

    private static boolean hasUtf32BEBOM(byte[] b, int len) {
        return len >= 4 && b[0] == 0 && b[1] == 0 && b[2] == -2 && b[3] == -1;
    }

    private static boolean hasUtf32LEBOM(byte[] b, int len) {
        return len >= 4 && b[0] == -1 && b[1] == -2 && b[2] == 0 && b[3] == 0;
    }

    private static boolean hasUtf7BOM(byte[] b, int len) {
        if (len < 4 || b[0] != 43 || b[1] != 47 || b[2] != 118) {
            return false;
        }
        byte b3 = b[3];
        return b3 == 56 || b3 == 57 || b3 == 43 || b3 == 47;
    }

    private static boolean hasUtf1BOM(byte[] b, int len) {
        return len >= 3 && b[0] == -9 && b[1] == 100 && b[2] == 76;
    }

    static {
        try {
            CHARSET_BYTES = "charset".getBytes(ISO_8859_1);
            ENCODING_BYTES = "encoding".getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
    }
}

