/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.Arrays;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.query.AndQueryNode;
import org.exoplatform.services.jcr.impl.core.query.DerefQueryNode;
import org.exoplatform.services.jcr.impl.core.query.ExactQueryNode;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NotQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrderQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PathQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PropertyFunctionQueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryConstants;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.RelationQueryNode;
import org.exoplatform.services.jcr.impl.core.query.TextsearchQueryNode;

public class QueryTreeDump
implements QueryNodeVisitor {
    private int indent;
    private static char[] PADDING = new char[255];
    private static final char PADDING_CHAR = ' ';

    private QueryTreeDump(QueryNode node, StringBuilder buffer) throws RepositoryException {
        node.accept(this, buffer);
    }

    public static void dump(QueryNode node, StringBuilder buffer) throws RepositoryException {
        new QueryTreeDump(node, buffer);
    }

    public Object visit(QueryRootNode node, Object data) throws RepositoryException {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append("+ Root node");
        buffer.append("\n");
        InternalQName[] select = node.getSelectProperties();
        buffer.append("+ Select properties: ");
        if (select.length == 0) {
            buffer.append("*");
        } else {
            String comma = "";
            for (int i = 0; i < select.length; ++i) {
                buffer.append(comma);
                buffer.append(select[i].toString());
                comma = ", ";
            }
        }
        buffer.append("\n");
        this.traverse(new QueryNode[]{node.getLocationNode()}, buffer);
        OrderQueryNode order = node.getOrderNode();
        if (order != null) {
            this.traverse(new QueryNode[]{order}, buffer);
        }
        return buffer;
    }

    public Object visit(OrQueryNode node, Object data) throws RepositoryException {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ OrQueryNode");
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    public Object visit(AndQueryNode node, Object data) throws RepositoryException {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ AndQueryNode");
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    public Object visit(NotQueryNode node, Object data) throws RepositoryException {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ NotQueryNode");
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    public Object visit(ExactQueryNode node, Object data) {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ ExactQueryNode: ");
        buffer.append(" Prop=").append((Object)node.getPropertyName());
        buffer.append(" Value=").append((Object)node.getValue());
        buffer.append("\n");
        return buffer;
    }

    public Object visit(NodeTypeQueryNode node, Object data) {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ NodeTypeQueryNode: ");
        buffer.append(" Prop=").append(node.getPropertyName().getAsString());
        buffer.append(" Value=").append(node.getValue().getAsString());
        buffer.append("\n");
        return buffer;
    }

    public Object visit(TextsearchQueryNode node, Object data) {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ TextsearchQueryNode: ");
        buffer.append(" Path=");
        QPath relPath = node.getRelativePath();
        if (relPath == null) {
            buffer.append(".");
        } else {
            QPathEntry[] elements = relPath.getEntries();
            String slash = "";
            for (int i = 0; i < elements.length; ++i) {
                buffer.append(slash);
                slash = "/";
                if (node.getReferencesProperty() && i == elements.length - 1) {
                    buffer.append("@");
                }
                buffer.append(elements[i].getAsString());
            }
        }
        buffer.append(" Query=").append(node.getQuery());
        buffer.append("\n");
        return buffer;
    }

    public Object visit(PathQueryNode node, Object data) throws RepositoryException {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ PathQueryNode");
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    public Object visit(LocationStepQueryNode node, Object data) throws RepositoryException {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ LocationStepQueryNode: ");
        buffer.append(" NodeTest=");
        if (node.getNameTest() == null) {
            buffer.append("*");
        } else {
            buffer.append(node.getNameTest().getAsString());
        }
        buffer.append(" Descendants=").append(node.getIncludeDescendants());
        buffer.append(" Index=");
        if (node.getIndex() == -2147483647) {
            buffer.append("NONE");
        } else if (node.getIndex() == Integer.MIN_VALUE) {
            buffer.append("last()");
        } else {
            buffer.append(node.getIndex());
        }
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    public Object visit(RelationQueryNode node, Object data) throws RepositoryException {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ RelationQueryNode: Op: ");
        buffer.append(QueryConstants.OPERATION_NAMES.getName(node.getOperation()));
        buffer.append(" Prop=");
        QPath relPath = node.getRelativePath();
        if (relPath == null) {
            buffer.append(relPath);
        } else {
            QueryTreeDump.appendPath(relPath, buffer);
        }
        buffer.append(" Type=").append(QueryConstants.TYPE_NAMES.getName(node.getValueType()));
        if (node.getValueType() == 4) {
            buffer.append(" Value=").append(node.getDateValue());
        } else if (node.getValueType() == 2) {
            buffer.append(" Value=").append(node.getDoubleValue());
        } else if (node.getValueType() == 1) {
            buffer.append(" Value=").append(node.getLongValue());
        } else if (node.getValueType() == 6) {
            buffer.append(" Value=").append(node.getPositionValue());
        } else if (node.getValueType() == 3) {
            buffer.append(" Value=").append(node.getStringValue());
        } else if (node.getValueType() == 5) {
            buffer.append(" Value=").append(node.getDateValue());
        }
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    public Object visit(OrderQueryNode node, Object data) {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ OrderQueryNode");
        buffer.append("\n");
        OrderQueryNode.OrderSpec[] specs = node.getOrderSpecs();
        for (int i = 0; i < specs.length; ++i) {
            buffer.append(PADDING, 0, this.indent);
            buffer.append("  ");
            QueryTreeDump.appendPath(specs[i].getPropertyPath(), buffer);
            buffer.append(" asc=").append(specs[i].isAscending());
            buffer.append("\n");
        }
        return buffer;
    }

    public Object visit(DerefQueryNode node, Object data) throws RepositoryException {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ DerefQueryNode: ");
        buffer.append(" NodeTest=");
        if (node.getNameTest() == null) {
            buffer.append("*");
        } else {
            buffer.append((Object)node.getNameTest());
        }
        buffer.append(" Descendants=").append(node.getIncludeDescendants());
        buffer.append(" Index=");
        if (node.getIndex() == -2147483647) {
            buffer.append("NONE");
        } else if (node.getIndex() == Integer.MIN_VALUE) {
            buffer.append("last()");
        } else {
            buffer.append(node.getIndex());
        }
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    public Object visit(PropertyFunctionQueryNode node, Object data) {
        StringBuilder buffer = (StringBuilder)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ PropertyFunctionQueryNode: ");
        buffer.append(node.getFunctionName());
        buffer.append("()\n");
        return buffer;
    }

    private void traverse(QueryNode[] node, StringBuilder buffer) throws RepositoryException {
        this.indent += 2;
        if (this.indent > PADDING.length) {
            char[] tmp = new char[this.indent * 2];
            Arrays.fill(tmp, ' ');
            PADDING = tmp;
        }
        for (int i = 0; i < node.length; ++i) {
            node[i].accept(this, buffer);
        }
        this.indent -= 2;
    }

    private static void appendPath(QPath relPath, StringBuilder buffer) {
        QPathEntry[] elements = relPath.getEntries();
        String slash = "";
        for (int i = 0; i < elements.length; ++i) {
            buffer.append(slash);
            slash = "/";
            buffer.append(elements[i].getAsString(true));
        }
    }

    static {
        Arrays.fill(PADDING, ' ');
    }
}

