/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

import java.io.File;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.ResumeException;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.jcr.impl.backup.Suspendable;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.quota.ApplyPersistedChangesTask;
import org.exoplatform.services.jcr.impl.quota.CalculateNodeDataSizeTool;
import org.exoplatform.services.jcr.impl.quota.ChangesItem;
import org.exoplatform.services.jcr.impl.quota.ChangesListener;
import org.exoplatform.services.jcr.impl.quota.QuotaExecutorService;
import org.exoplatform.services.jcr.impl.quota.QuotaManagerException;
import org.exoplatform.services.jcr.impl.quota.QuotaPersister;
import org.exoplatform.services.jcr.impl.quota.RepositoryQuotaManager;
import org.exoplatform.services.jcr.impl.quota.UnknownDataSizeException;
import org.exoplatform.services.jcr.impl.quota.WorkspaceQuotaContext;
import org.exoplatform.services.jcr.impl.quota.WorkspaceQuotaRestore;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.rpc.RPCException;
import org.exoplatform.services.rpc.RPCService;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="WorkspaceQuotaManager")})
public class WorkspaceQuotaManager
implements Startable,
Backupable,
Suspendable {
    protected final String wsName;
    protected final String rName;
    protected final String uniqueName;
    protected final WorkspaceContainerFacade wsContainer;
    protected final WorkspacePersistentDataManager dataManager;
    protected final RepositoryQuotaManager repositoryQuotaManager;
    protected final QuotaExecutorService executor;
    protected final QuotaPersister quotaPersister;
    protected final RPCService rpcService;
    protected final ChangesListener changesListener;
    protected final AtomicBoolean isSuspended = new AtomicBoolean();
    protected final WorkspaceQuotaContext context;
    protected final CalculateNodeDataSizeTool calculateNodeDataSizeTool;

    public WorkspaceQuotaManager(RepositoryImpl repository, RepositoryQuotaManager rQuotaManager, RepositoryEntry rEntry, WorkspaceEntry wsEntry, WorkspacePersistentDataManager dataManager) {
        this.rName = rEntry.getName();
        this.wsName = wsEntry.getName();
        this.uniqueName = "/" + this.rName + "/" + this.wsName;
        this.wsContainer = repository.getWorkspaceContainer(this.wsName);
        this.dataManager = dataManager;
        this.repositoryQuotaManager = rQuotaManager;
        this.quotaPersister = rQuotaManager.globalQuotaManager.quotaPersister;
        this.rpcService = rQuotaManager.globalQuotaManager.rpcService;
        this.executor = new QuotaExecutorService(this.uniqueName);
        this.repositoryQuotaManager.registerWorkspaceQuotaManager(this.wsName, this);
        this.context = new WorkspaceQuotaContext(this.wsName, this.rName, this.uniqueName, dataManager, repository.getLocationFactory(), this.executor, this.quotaPersister, this.rpcService, rQuotaManager.globalQuotaManager.exceededQuotaBehavior);
        this.changesListener = new ChangesListener(this);
        this.calculateNodeDataSizeTool = new CalculateNodeDataSizeTool(this.context);
        dataManager.addItemPersistenceListener(this.changesListener);
    }

    @Managed
    @ManagedDescription(value="Returns a node data size")
    public long getNodeDataSize(@ManagedName(value="nodePath") String nodePath) throws QuotaManagerException {
        if (nodePath.equals("/")) {
            return this.getWorkspaceDataSize();
        }
        return this.quotaPersister.getNodeDataSize(this.rName, this.wsName, nodePath);
    }

    @Managed
    @ManagedDescription(value="Returns a node quota limit")
    public long getNodeQuota(@ManagedName(value="nodePath") String nodePath) throws QuotaManagerException {
        if (nodePath.equals("/")) {
            return this.getWorkspaceQuota();
        }
        return this.quotaPersister.getNodeQuotaOrGroupOfNodesQuota(this.rName, this.wsName, nodePath);
    }

    @Managed
    @ManagedDescription(value="Sets a node quota limit")
    public void setNodeQuota(@ManagedName(value="nodePath") String nodePath, @ManagedName(value="quotaLimit") long quotaLimit, @ManagedName(value="asyncUpdate") boolean asyncUpdate) throws QuotaManagerException {
        if (nodePath.equals("/")) {
            this.setWorkspaceQuota(quotaLimit);
        } else {
            this.quotaPersister.setNodeQuota(this.rName, this.wsName, nodePath, quotaLimit, asyncUpdate);
        }
    }

    @Managed
    @ManagedDescription(value="Sets a quota limit for a bunch of nodes")
    public void setGroupOfNodesQuota(@ManagedName(value="patternPath") String patternPath, @ManagedName(value="quotaLimit") long quotaLimit, @ManagedName(value="asyncUpdate") boolean asyncUpdate) throws QuotaManagerException {
        if (patternPath.equals("/")) {
            this.setWorkspaceQuota(quotaLimit);
        } else {
            this.quotaPersister.setGroupOfNodesQuota(this.rName, this.wsName, patternPath, quotaLimit, asyncUpdate);
        }
    }

    @Managed
    @ManagedDescription(value="Removes a quota limit for a node")
    public void removeNodeQuota(@ManagedName(value="nodePath") String nodePath) throws QuotaManagerException {
        if (nodePath.equals("/")) {
            this.removeWorkspaceQuota();
        } else {
            this.quotaPersister.removeNodeQuotaAndDataSize(this.rName, this.wsName, nodePath);
        }
    }

    @Managed
    @ManagedDescription(value="Removes a quota limit for a bunch of nodes")
    public void removeGroupOfNodesQuota(@ManagedName(value="patternPath") String patternPath) throws QuotaManagerException {
        if (patternPath.equals("/")) {
            this.removeWorkspaceQuota();
        } else {
            this.quotaPersister.removeGroupOfNodesAndDataSize(this.rName, this.wsName, patternPath);
        }
    }

    @Managed
    @ManagedDescription(value="Sets workspace quota limit")
    public void setWorkspaceQuota(long quotaLimit) throws QuotaManagerException {
        this.quotaPersister.setWorkspaceQuota(this.rName, this.wsName, quotaLimit);
    }

    @Managed
    @ManagedDescription(value="Removes workspace quota limit")
    public void removeWorkspaceQuota() throws QuotaManagerException {
        this.quotaPersister.removeWorkspaceQuota(this.rName, this.wsName);
    }

    @Managed
    @ManagedDescription(value="Returns workspace quota limit")
    public long getWorkspaceQuota() throws QuotaManagerException {
        return this.quotaPersister.getWorkspaceQuota(this.rName, this.wsName);
    }

    @Managed
    @ManagedDescription(value="Returns a size of the Workspace")
    public long getWorkspaceDataSize() throws QuotaManagerException {
        return this.quotaPersister.getWorkspaceDataSize(this.rName, this.wsName);
    }

    @Managed
    @ManagedDescription(value="Returns a size of the index")
    public long getWorkspaceIndexSize() throws QuotaManagerException {
        try {
            return (Long)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws Exception {
                    Method getIndexDirMethod = SearchManager.class.getDeclaredMethod("getIndexDirectory", new Class[0]);
                    getIndexDirMethod.setAccessible(true);
                    List<SearchManager> searchers = WorkspaceQuotaManager.this.wsContainer.getComponentInstancesOfType(SearchManager.class);
                    long size = 0L;
                    for (SearchManager searchManager : searchers) {
                        File indexDir = (File)getIndexDirMethod.invoke((Object)searchManager, new Object[0]);
                        size += DirectoryHelper.getSize(indexDir);
                    }
                    return size;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new QuotaManagerException(e.getMessage(), e);
        }
    }

    public long getNodeDataSizeDirectly(final String nodePath) throws QuotaManagerException {
        try {
            return (Long)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws Exception {
                    if (nodePath.equals("/")) {
                        return WorkspaceQuotaManager.this.getWorkspaceDataSizeDirectly();
                    }
                    return WorkspaceQuotaManager.this.calculateNodeDataSizeTool.getNodeDataSizeDirectly(nodePath);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new QuotaManagerException(e.getMessage(), e);
        }
    }

    public long getWorkspaceDataSizeDirectly() throws QuotaManagerException {
        try {
            return this.dataManager.getWorkspaceDataSize();
        }
        catch (RepositoryException e) {
            throw new QuotaManagerException(e.getMessage(), e);
        }
    }

    public void start() {
        boolean isCoordinator;
        try {
            isCoordinator = this.rpcService.isCoordinator();
        }
        catch (RPCException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        if (isCoordinator) {
            try {
                this.quotaPersister.getWorkspaceDataSize(this.rName, this.wsName);
            }
            catch (UnknownDataSizeException e) {
                this.calculateWorkspaceDataSize();
            }
        }
    }

    public void stop() {
        this.executor.shutdownNow();
        this.repositoryQuotaManager.unregisterWorkspaceQuotaManager(this.wsName);
        this.changesListener.destroy();
        this.dataManager.removeItemPersistenceListener(this.changesListener);
    }

    protected WorkspaceQuotaContext getContext() {
        return this.context;
    }

    public void backup(File storageDir) throws BackupException {
        WorkspaceQuotaRestore wqr = new WorkspaceQuotaRestore(this, storageDir);
        wqr.backup();
    }

    public void clean() throws BackupException {
        File storageDir = new File(PrivilegedSystemHelper.getProperty((String)"java.io.tmpdir"));
        WorkspaceQuotaRestore wqr = new WorkspaceQuotaRestore(this, storageDir);
        wqr.clean();
    }

    public DataRestore getDataRestorer(DataRestoreContext context) throws BackupException {
        return new WorkspaceQuotaRestore(this, context);
    }

    public void suspend() throws SuspendException {
        this.executor.suspend();
        this.isSuspended.set(true);
    }

    public void resume() throws ResumeException {
        this.executor.resume();
        this.isSuspended.set(false);
    }

    public boolean isSuspended() {
        return this.isSuspended.get();
    }

    public int getPriority() {
        return -5;
    }

    protected void pushAllChangesToCoordinator() throws QuotaManagerException {
        try {
            this.changesListener.pushAllChangesToCoordinator();
        }
        catch (SecurityException e) {
            throw new QuotaManagerException("Can't push changes to coordinator", e);
        }
        catch (RPCException e) {
            throw new QuotaManagerException("Can't push changes to coordinator", e);
        }
    }

    private void calculateWorkspaceDataSize() {
        long dataSize;
        try {
            dataSize = this.getWorkspaceDataSizeDirectly();
        }
        catch (QuotaManagerException e1) {
            throw new IllegalStateException("Can't calculate workspace data size", e1);
        }
        ChangesItem changesItem = new ChangesItem();
        changesItem.updateWorkspaceChangedSize(dataSize);
        ApplyPersistedChangesTask task = new ApplyPersistedChangesTask(this.context, changesItem);
        task.run();
    }
}

