/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.StringListAccess;
import org.exoplatform.social.webui.UIUsersInGroupSelector;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.organization.account.UIUserSelector;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/space/UISpaceMember.gtmpl", events={@EventConfig(listeners={InviteActionListener.class}), @EventConfig(listeners={SearchUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RevokeInvitedUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeclineUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ValidateUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveLeaderActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={MakeLeaderActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ToggleLeadershipActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIPopupWindow.class, id="SearchUser", template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="ClosePopup"), @EventConfig(listeners={CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={SelectGroupActionListener.class}, phase=Event.Phase.DECODE)})})
public class UISpaceMember
extends UIForm {
    private static final String MSG_ERROR_SELF_REMOVE_LEADER = "UISpaceMember.msg.error_self_remove_leader";
    private static final String MSG_ERROR_SELF_REMOVE_LEADER_YOU = "UISpaceMember.msg.error_self_remove_leader_you";
    private static final String MSG_ERROR_SELF_REMOVE_LEADER_ARE = "UISpaceMember.msg.error_self_remove_leader_are";
    private static final String MSG_ERROR_SELF_REMOVE_LEADER_IS = "UISpaceMember.msg.error_self_remove_leader_is";
    private static final String MSG_ERROR_SELF_REMOVE_LEADER_LEAVING_IT = "UISpaceMember.msg.error_self_remove_leader_leaving_it";
    private static final String MSG_ERROR_SELF_REMOVE_LEADER_REMOVING_THE_RIGHTS = "UISpaceMember.msg.error_self_remove_leader_removing_the_rights";
    private static final int FIRST_PAGE = 1;
    private String spaceId;
    private SpaceService spaceService = null;
    private static final String USER = "user";
    private UIPageIterator iteratorPendingUsers;
    private UIPageIterator iteratorInvitedUsers;
    private UIPageIterator iteratorExistingUsers;
    private final String iteratorPendingID = "UIIteratorPendding";
    private final String iteratorInvitedID = "UIIteratorInvited";
    private final String iteratorExistingID = "UIIteratorExisting";
    private final Integer ITEMS_PER_PAGE = 3;
    private static final String USER_TO_INVITE = "user_to_invite";
    String typeOfRelation = null;
    String spaceURL = null;
    private static String invitedUserNames;
    private boolean hasErr = false;
    private boolean isNewSearch;

    public UISpaceMember() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(USER, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIPopupWindow searchUserPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, "SearchUser", "SearchUser");
        searchUserPopup.setWindowSize(640, 0);
        this.iteratorPendingUsers = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorPendding");
        this.iteratorInvitedUsers = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorInvited");
        this.iteratorExistingUsers = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorExisting");
        this.addChild((UIComponent)this.iteratorPendingUsers);
        this.addChild((UIComponent)this.iteratorInvitedUsers);
        this.addChild((UIComponent)this.iteratorExistingUsers);
        this.setTypeOfRelation(USER_TO_INVITE);
        invitedUserNames = null;
        this.setSubmitAction("return false;");
    }

    public UIPageIterator getUIPageIteratorPendingUsers() {
        return this.iteratorPendingUsers;
    }

    public UIPageIterator getUIPageIteratorInvitedUsers() {
        return this.iteratorInvitedUsers;
    }

    public UIPageIterator getUIPageIteratorExistingUsers() {
        return this.iteratorExistingUsers;
    }

    public void setValue(String spaceId) throws Exception {
        this.spaceId = spaceId;
    }

    public String getTypeOfRelation() {
        return this.typeOfRelation;
    }

    public void setTypeOfRelation(String typeOfRelation) {
        this.typeOfRelation = typeOfRelation;
    }

    public String getSpaceURL() {
        return this.spaceURL;
    }

    public void setSpaceURL(String spaceURL) {
        this.spaceURL = spaceURL;
    }

    public boolean isHasErr() {
        return this.hasErr;
    }

    public void setHasErr(boolean hasErr) {
        this.hasErr = hasErr;
    }

    public String getCurrentUserName() {
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    protected String getRestContextName() {
        return PortalContainer.getCurrentRestContextName();
    }

    protected String getPortalName() {
        return PortalContainer.getCurrentPortalContainerName();
    }

    public List<String> getPendingUsers() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        if (space == null) {
            return new ArrayList<String>(0);
        }
        String[] pendingUsers = space.getPendingUsers();
        if (pendingUsers == null || pendingUsers.length == 0) {
            return new ArrayList<String>();
        }
        int currentPage = this.iteratorPendingUsers.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new StringListAccess(Arrays.asList(pendingUsers)), this.ITEMS_PER_PAGE.intValue());
        this.iteratorPendingUsers.setPageList((PageList)pageList);
        int pageCount = this.iteratorPendingUsers.getAvailablePage();
        if (pageCount >= currentPage) {
            this.iteratorPendingUsers.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.iteratorPendingUsers.setCurrentPage(currentPage - 1);
        }
        return this.iteratorPendingUsers.getCurrentPageData();
    }

    public List<String> getInvitedUsers() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        if (space == null) {
            return new ArrayList<String>(0);
        }
        String[] invitedUsers = space.getInvitedUsers();
        if (invitedUsers == null || invitedUsers.length == 0) {
            return new ArrayList<String>();
        }
        int currentPage = this.iteratorInvitedUsers.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new StringListAccess(Arrays.asList(invitedUsers)), this.ITEMS_PER_PAGE.intValue());
        this.iteratorInvitedUsers.setPageList((PageList)pageList);
        int pageCount = this.iteratorInvitedUsers.getAvailablePage();
        if (pageCount >= currentPage) {
            this.iteratorInvitedUsers.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.iteratorInvitedUsers.setCurrentPage(currentPage - 1);
        }
        return this.iteratorInvitedUsers.getCurrentPageData();
    }

    public List<String> getExistingUsers() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        if (space == null) {
            return new ArrayList<String>(0);
        }
        String[] memberUsers = space.getMembers();
        if (memberUsers == null || memberUsers.length == 0) {
            return new ArrayList<String>();
        }
        int currentPage = this.iteratorExistingUsers.getCurrentPage();
        HashSet<String> users = new HashSet<String>(Arrays.asList(memberUsers));
        users.addAll(SpaceUtils.findMembershipUsersByGroupAndTypes((String)space.getGroupId(), (String[])new String[]{"*"}));
        LazyPageList pageList = new LazyPageList((ListAccess)new StringListAccess(new ArrayList<String>(users)), this.ITEMS_PER_PAGE.intValue());
        this.iteratorExistingUsers.setPageList((PageList)pageList);
        if (this.isNewSearch()) {
            this.iteratorExistingUsers.setCurrentPage(1);
        } else {
            this.iteratorExistingUsers.setCurrentPage(currentPage);
        }
        this.setNewSearch(false);
        return this.iteratorExistingUsers.getCurrentPageData();
    }

    public void setUsersName(String userName) {
        this.getUIStringInput(USER).setValue((Object)userName);
    }

    public String getUsersName() {
        String value = (String)this.getUIStringInput(USER).getValue();
        return value != null ? value : "";
    }

    public boolean isSuperUser() throws Exception {
        return this.getRemoteUser().equals(this.getUserACL().getSuperUser());
    }

    public String getHomeSpaceUrl() throws Exception {
        Space space = this.getSpaceService().getSpaceById(this.spaceId);
        return Utils.getSpaceHomeURL(space);
    }

    public String getManageSpacesUrl() throws Exception {
        return Utils.getURI("spaces");
    }

    public boolean isLeader(String userName) throws Exception {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        return spaceService.isManager(space, userName);
    }

    protected boolean hasWildCardMembership(String userId) {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        return SpaceUtils.isUserHasMembershipTypesInGroup((String)userId, (String)space.getGroupId(), (String)"*");
    }

    public boolean isCurrentUser(String userName) throws Exception {
        return this.getRemoteUser().equals(userName);
    }

    private void validateInvitedUser(String userNameForInvite) throws Exception {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIApplication uiApp = requestContext.getUIApplication();
        String[] invitedUserList = userNameForInvite.split(",");
        String invitedUser = null;
        ApplicationMessage appMsg = null;
        invitedUserNames = null;
        ArrayList<String> validUsers = new ArrayList<String>();
        ArrayList<String> invitedUsers = new ArrayList<String>();
        ArrayList<String> memberUsers = new ArrayList<String>();
        ArrayList<String> notExistUsers = new ArrayList<String>();
        for (String userStr : invitedUserList) {
            invitedUser = userStr.trim();
            if (invitedUser.length() == 0) continue;
            if (this.isMember(invitedUser)) {
                memberUsers.add(invitedUser);
                continue;
            }
            if (this.isNotExisted(invitedUser)) {
                notExistUsers.add(invitedUser);
                continue;
            }
            if (this.hasInvited(invitedUser)) {
                invitedUsers.add(invitedUser);
                continue;
            }
            validUsers.add(invitedUser);
        }
        if (validUsers.size() > 0) {
            this.setUsersName(StringUtils.join(validUsers, (char)','));
            invitedUserNames = StringUtils.join(validUsers, (char)',');
        }
        if (notExistUsers.size() > 0) {
            this.setHasErr(true);
            appMsg = new ApplicationMessage("UISpaceMember.msg.user-not-exist", (Object[])notExistUsers.toArray(new String[notExistUsers.size()]), 1);
            appMsg.setArgsLocalized(false);
            uiApp.addMessage(appMsg);
        }
        if (invitedUsers.size() > 0) {
            this.setHasErr(true);
            appMsg = new ApplicationMessage("UISpaceMember.msg.user-is-invited", (Object[])invitedUsers.toArray(new String[invitedUsers.size()]), 1);
            appMsg.setArgsLocalized(false);
            uiApp.addMessage(appMsg);
        }
        if (memberUsers.size() > 0) {
            this.setHasErr(true);
            appMsg = new ApplicationMessage("UISpaceMember.msg.user-is-member", (Object[])memberUsers.toArray(new String[memberUsers.size()]), 1);
            appMsg.setArgsLocalized(false);
            uiApp.addMessage(appMsg);
        }
    }

    protected boolean isMember(String userId) {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        try {
            if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean hasInvited(String userId) {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        try {
            if (spaceService.isInvitedUser(space, userId)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean isNotExisted(String userId) {
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        try {
            User user = orgService.getUserHandler().findUserByName(userId);
            if (user != null) {
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private UserACL getUserACL() throws Exception {
        return (UserACL)this.getApplicationComponent(UserACL.class);
    }

    private String getRemoteUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public String getFullName(String userId) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        Identity identity = idm.getOrCreateIdentity("organization", userId, true);
        if (identity == null) {
            return "";
        }
        return identity.getProfile().getFullName();
    }

    public boolean isNewSearch() {
        return this.isNewSearch;
    }

    public void setNewSearch(boolean isNewSearch) {
        this.isNewSearch = isNewSearch;
    }

    private String[] makeParamSelfRemoveLeaderErrorMessage(String userName, String currentUser) {
        if (userName == null || currentUser == null) {
            return null;
        }
        if (currentUser.equals(userName)) {
            return new String[]{MSG_ERROR_SELF_REMOVE_LEADER_YOU, MSG_ERROR_SELF_REMOVE_LEADER_ARE, MSG_ERROR_SELF_REMOVE_LEADER_LEAVING_IT};
        }
        return new String[]{this.getFullName(userName), MSG_ERROR_SELF_REMOVE_LEADER_IS, MSG_ERROR_SELF_REMOVE_LEADER_REMOVING_THE_RIGHTS};
    }

    public static class CloseActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiForm = (UIUserSelector)event.getSource();
            UISpaceMember uiSpaceMember = (UISpaceMember)uiForm.getAncestorOfType(UISpaceMember.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceMember.getChild(UIPopupWindow.class);
            uiPopup.setUIComponent(null);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class SelectGroupActionListener
    extends EventListener<UIUsersInGroupSelector> {
        public void execute(Event<UIUsersInGroupSelector> event) throws Exception {
            String selectedGroupId = event.getRequestContext().getRequestParameter("objectId");
            UIUsersInGroupSelector uiForm = (UIUsersInGroupSelector)((Object)event.getSource());
            UISpaceMember uiSpaceMember = (UISpaceMember)uiForm.getAncestorOfType(UISpaceMember.class);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            OrganizationService orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            ListAccess groupMembersAccess = orgService.getUserHandler().findUsersByGroupId(selectedGroupId);
            String userNamesInputted = uiSpaceMember.getUsersName();
            if (groupMembersAccess != null && groupMembersAccess.getSize() > 0) {
                User[] users = (User[])groupMembersAccess.load(0, groupMembersAccess.getSize());
                SpaceService spaceService = uiSpaceMember.getSpaceService();
                Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
                for (User user : users) {
                    String userId = user.getUserName();
                    Object[] invitedUsers = space.getInvitedUsers();
                    Object[] pendingUsers = space.getPendingUsers();
                    Object[] members = space.getMembers();
                    if (ArrayUtils.contains((Object[])invitedUsers, (Object)userId) || ArrayUtils.contains((Object[])pendingUsers, (Object)userId) || ArrayUtils.contains((Object[])members, (Object)userId)) continue;
                    userNamesInputted = userNamesInputted == null || userNamesInputted.length() == 0 ? userId : userNamesInputted.trim() + ", " + userId;
                }
            }
            uiSpaceMember.validateInvitedUser(userNamesInputted);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceMember.getChild(UIPopupWindow.class);
            uiPopup.setUIComponent(null);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class AddActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiForm = (UIUserSelector)event.getSource();
            UISpaceMember uiSpaceMember = (UISpaceMember)uiForm.getAncestorOfType(UISpaceMember.class);
            String userNamesSelected = uiForm.getSelectedUsers();
            String userNamesInputted = uiSpaceMember.getUsersName();
            String userNameForInvite = null;
            userNameForInvite = userNamesInputted == null || userNamesInputted.length() == 0 ? userNamesSelected : userNamesInputted.trim() + ", " + userNamesSelected;
            uiSpaceMember.validateInvitedUser(userNameForInvite);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceMember.getChild(UIPopupWindow.class);
            uiPopup.setUIComponent(null);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class MakeLeaderActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
            space.setEditor(Utils.getViewerRemoteId());
            spaceService.setManager(space, userName, true);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class RemoveLeaderActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            UIApplication uiApp = requestContext.getUIApplication();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            PortalRequestContext prContext = Util.getPortalRequestContext();
            String currentUser = requestContext.getRemoteUser();
            boolean useAjax = prContext.useAjax();
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
            if (!useAjax) {
                userName = currentUser;
            }
            if (spaceService.isOnlyManager(space, userName)) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_SELF_REMOVE_LEADER, (Object[])uiSpaceMember.makeParamSelfRemoveLeaderErrorMessage(userName, currentUser), 1));
                return;
            }
            space.setEditor(Utils.getViewerRemoteId());
            spaceService.setManager(space, userName, false);
            if (!useAjax) {
                prContext = Util.getPortalRequestContext();
                prContext.setResponseComplete(true);
                StringBuffer url = new StringBuffer(Utils.getSpaceHomeURL(space));
                if (uiSpaceMember.isSuperUser()) {
                    url.append("/SpaceSettingPortlet");
                }
                prContext.getResponse().sendRedirect(url.toString());
                return;
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class ToggleLeadershipActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext rcontext = event.getRequestContext();
            String targetUser = rcontext.getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
            space.setEditor(Utils.getViewerRemoteId());
            boolean success = false;
            if (spaceService.isManager(space, targetUser)) {
                if (spaceService.isOnlyManager(space, targetUser)) {
                    UIApplication uiApp = rcontext.getUIApplication();
                    String currentUser = rcontext.getRemoteUser();
                    uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_SELF_REMOVE_LEADER, (Object[])uiSpaceMember.makeParamSelfRemoveLeaderErrorMessage(targetUser, currentUser), 1));
                    return;
                }
                spaceService.setManager(space, targetUser, false);
                success = true;
            } else if (spaceService.isMember(space, targetUser)) {
                spaceService.setManager(space, targetUser, true);
                success = true;
            }
            if (success) {
                ((WebuiRequestContext)rcontext.getParentAppRequestContext()).setResponseComplete(true);
            }
        }
    }

    public static class ValidateUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            spaceService.addMember(spaceService.getSpaceById(uiSpaceMember.spaceId), userName);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class RemoveUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            boolean useAjax = prContext.useAjax();
            UIApplication uiApp = requestContext.getUIApplication();
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
            String currentUser = requestContext.getRemoteUser();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            if (!useAjax) {
                userName = currentUser;
            }
            if (spaceService.isOnlyManager(space, userName)) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_SELF_REMOVE_LEADER, (Object[])uiSpaceMember.makeParamSelfRemoveLeaderErrorMessage(userName, currentUser), 1));
                return;
            }
            spaceService.removeMember(space, userName);
            spaceService.setManager(spaceService.getSpaceById(space.getId()), userName, false);
            if (!useAjax) {
                prContext = Util.getPortalRequestContext();
                prContext.setResponseComplete(true);
                StringBuffer url = new StringBuffer();
                if (uiSpaceMember.isSuperUser()) {
                    url.append(Utils.getSpaceHomeURL(space)).append("/SpaceSettingPortlet");
                } else {
                    url.append(Utils.getURI("spaces"));
                }
                prContext.getResponse().sendRedirect(url.toString());
                return;
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class DeclineUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            spaceService.removePendingUser(spaceService.getSpaceById(uiSpaceMember.spaceId), userName);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class RevokeInvitedUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            spaceService.removeInvitedUser(spaceService.getSpaceById(uiSpaceMember.spaceId), userName);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class SearchGroupActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            UIPopupWindow searchGroupPopup = (UIPopupWindow)uiSpaceMember.getChild(UIPopupWindow.class);
            UIUsersInGroupSelector groupSelector = (UIUsersInGroupSelector)uiSpaceMember.createUIComponent(UIUsersInGroupSelector.class, null, null);
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
            groupSelector.setCurrentGroupId(space.getGroupId());
            uiSpaceMember.setNewSearch(true);
            searchGroupPopup.setUIComponent((UIComponent)groupSelector);
            searchGroupPopup.setShow(true);
        }
    }

    public static class SearchUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            UIPopupWindow searchUserPopup = (UIPopupWindow)uiSpaceMember.getChild(UIPopupWindow.class);
            UIUserSelector userSelector = (UIUserSelector)uiSpaceMember.createUIComponent(UIUserSelector.class, null, null);
            uiSpaceMember.setNewSearch(true);
            userSelector.setShowSearchGroup(false);
            searchUserPopup.setUIComponent((UIComponent)userSelector);
            searchUserPopup.setShow(true);
        }
    }

    public static class InviteActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            uiSpaceMember.setHasErr(false);
            uiSpaceMember.validateInvitedUser(uiSpaceMember.getUsersName());
            Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
            if (invitedUserNames != null) {
                String[] invitedUsers = invitedUserNames.split(",");
                String name = null;
                ArrayList<String> usersForInviting = new ArrayList<String>();
                if (invitedUsers != null) {
                    for (int idx = 0; idx < invitedUsers.length; ++idx) {
                        name = invitedUsers[idx].trim();
                        if (name.equals(uiSpaceMember.getUserACL().getSuperUser())) {
                            spaceService.addMember(space, name);
                            continue;
                        }
                        if (name.length() <= 0 || usersForInviting.contains(name) || ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)name)) continue;
                        usersForInviting.add(name);
                    }
                }
                for (String userName : usersForInviting) {
                    ExoContainer container = ExoContainerContext.getCurrentContainer();
                    IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
                    Identity identity = idm.getOrCreateIdentity("organization", userName, false);
                    if (identity == null) continue;
                    spaceService.addInvitedUser(space, userName);
                }
                uiSpaceMember.setUsersName("");
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }
}

