/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WebNotificationServiceImpl
implements WebNotificationService {
    private static final Log LOG = ExoLogger.getLogger(WebNotificationServiceImpl.class);
    private final WebNotificationStorage storage;

    public WebNotificationServiceImpl(WebNotificationStorage webStorage) {
        this.storage = webStorage;
    }

    public void save(NotificationInfo notification) {
        this.storage.save(notification);
    }

    public void markRead(String notificationId) {
        this.storage.markRead(notificationId);
    }

    public void markAllRead(String userId) {
        this.storage.markAllRead(userId);
    }

    public List<String> get(WebNotificationFilter filter, int offset, int limit) {
        ArrayList<String> result = new ArrayList<String>();
        List gotList = this.storage.get(filter, offset, limit);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        AbstractChannel channel = ctx.getChannelManager().getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        for (NotificationInfo notification : gotList) {
            AbstractTemplateBuilder builder = channel.getTemplateBuilder(notification.getKey());
            MessageInfo msg = builder.buildMessage(ctx.setNotificationInfo(notification));
            if (msg != null && msg.getBody() != null && !msg.getBody().isEmpty()) {
                result.add(msg.getBody());
            }
            if (!ctx.isFailed()) continue;
            LOG.debug((Object)ctx.getException().getMessage(), (Throwable)ctx.getException());
        }
        return result;
    }

    public boolean remove(String notificationId) {
        return this.storage.remove(notificationId);
    }

    public void hidePopover(String notificationId) {
        this.storage.hidePopover(notificationId);
    }

    public void resetNumberOnBadge(String userId) {
        this.storage.resetNumberOnBadge(userId);
    }

    public int getNumberOnBadge(String userId) {
        return this.storage.getNumberOnBadge(userId);
    }
}

