/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.lang.ref.WeakReference;
import java.util.Set;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.UnifiedClassLoader;
import org.exoplatform.container.WebAppInitContext;

class PortalContainerClassLoader
extends UnifiedClassLoader {
    private volatile WeakReference<PortalContainer> containerRef;
    private final String portalContainerName;

    PortalContainerClassLoader(PortalContainer container) {
        super(PortalContainerClassLoader.getClassLoaders(container));
        this.containerRef = new WeakReference<PortalContainer>(container);
        this.portalContainerName = container.getName();
    }

    private static ClassLoader[] getClassLoaders(PortalContainer container) {
        Set<WebAppInitContext> contexts = container.getWebAppInitContexts();
        ClassLoader[] cls = new ClassLoader[contexts.size()];
        int i = 0;
        for (WebAppInitContext ctx : contexts) {
            cls[i++] = ctx.getWebappClassLoader();
        }
        return cls;
    }

    protected ClassLoader[] getClassLoaders() {
        return PortalContainerClassLoader.getClassLoaders(this.getPortalContainer());
    }

    private PortalContainer getPortalContainer() {
        PortalContainer container = (PortalContainer)this.containerRef.get();
        if (container != null) {
            return container;
        }
        container = RootContainer.getInstance().getPortalContainer(this.portalContainerName);
        this.containerRef = new WeakReference<PortalContainer>(container);
        return container;
    }
}

