/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.management;

import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import org.exoplatform.container.ConcurrentContainer;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.jmx.MX4JComponentAdapter;
import org.exoplatform.container.management.ManageableContainer;
import org.exoplatform.container.spi.Container;
import org.exoplatform.management.spi.ManagementProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageableComponentAdapter<T>
extends MX4JComponentAdapter<T> {
    private static final long serialVersionUID = 8922696628680586728L;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ManageableComponentAdapter");
    private final AtomicBoolean registered = new AtomicBoolean();

    public ManageableComponentAdapter(ExoContainer holder, ConcurrentContainer container, Object key, Class<T> implementation) {
        super(holder, container, key, implementation);
    }

    protected void register(Container co, Object instance) {
        if (this.registered.compareAndSet(false, true)) {
            while (!(co instanceof ManageableContainer) && (co = co.getSuccessor()) != null) {
            }
            if (co instanceof ManageableContainer) {
                ManageableContainer container = (ManageableContainer)co;
                if (container.managementContext != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("==> add " + instance + " to a mbean server"));
                    }
                    container.managementContext.register(instance);
                    if (instance instanceof ManagementProvider) {
                        ManagementProvider provider = (ManagementProvider)instance;
                        container.addProvider(provider);
                    }
                }
            }
        }
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        T instance = super.create(creationalContext);
        Class<Annotation> scope = null;
        if (instance != null && (scope = this.getScope()) != null && !scope.equals(Dependent.class) || this.isSingleton()) {
            this.register(this.exocontainer, instance);
        }
        return instance;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            Container co = this.exocontainer;
            while (!(co instanceof ManageableContainer) && (co = co.getSuccessor()) != null) {
            }
            if (co instanceof ManageableContainer) {
                ManageableContainer container = (ManageableContainer)co;
                if (container.managementContext != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("==> remove " + instance + " from a mbean server"));
                    }
                    container.managementContext.unregister(instance);
                }
            }
            creationalContext.release();
        }
        catch (Exception e) {
            LOG.error((Object)("Could not destroy the instance " + instance + ": " + e.getMessage()));
        }
    }
}

