/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.ext.organization.JCROrgServiceHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.UserProfileImpl;
import org.exoplatform.services.organization.CacheHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileEventListenerHandler;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.security.PermissionConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserProfileHandlerImpl
extends JCROrgServiceHandler
implements UserProfileHandler,
UserProfileEventListenerHandler {
    public static final String ATTRIBUTE_PREFIX = "attr.";
    protected final List<UserProfileEventListener> listeners = new ArrayList<UserProfileEventListener>();

    UserProfileHandlerImpl(JCROrganizationServiceImpl service) {
        super(service);
    }

    public UserProfile createUserProfileInstance() {
        return new UserProfileImpl();
    }

    public UserProfile createUserProfileInstance(String userName) {
        return new UserProfileImpl(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile findUserProfileByName(String userName) throws Exception {
        UserProfile profile = this.getFromCache(userName);
        if (profile != null) {
            return profile;
        }
        Session session = this.service.getStorageSession();
        try {
            profile = this.readProfile(session, userName);
            if (profile != null) {
                this.putInCache(profile);
            }
        }
        finally {
            session.logout();
        }
        return profile;
    }

    private UserProfile readProfile(Session session, String userName) throws Exception {
        Node profileNode;
        try {
            profileNode = this.utils.getProfileNode(session, userName);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        return this.readProfile(userName, profileNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UserProfile> findUserProfiles() throws Exception {
        ArrayList<UserProfile> profiles = new ArrayList<UserProfile>();
        Session session = this.service.getStorageSession();
        try {
            NodeIterator userNodes = this.utils.getUsersStorageNode(session).getNodes();
            while (userNodes.hasNext()) {
                Node profileNode;
                Node userNode = userNodes.nextNode();
                String userName = userNode.getName();
                try {
                    profileNode = userNode.getNode("jos:profile");
                }
                catch (PathNotFoundException e) {
                    continue;
                }
                UserProfile profile = this.readProfile(userName, profileNode);
                if (profile == null) continue;
                profiles.add(profile);
            }
        }
        finally {
            session.logout();
        }
        return profiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            UserProfile userProfile = this.removeUserProfile(session, userName, broadcast);
            return userProfile;
        }
        finally {
            session.logout();
        }
    }

    private UserProfile removeUserProfile(Session session, String userName, boolean broadcast) throws Exception {
        Node profileNode;
        try {
            profileNode = this.utils.getProfileNode(session, userName);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        UserProfile profile = this.readProfile(userName, profileNode);
        if (broadcast) {
            this.preDelete(profile, broadcast);
        }
        profileNode.remove();
        session.save();
        this.removeFromCache(profile);
        if (broadcast) {
            this.postDelete(profile);
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.saveUserProfile(session, profile, broadcast);
        }
        finally {
            session.logout();
        }
    }

    void migrateProfile(Node oldUserNode) throws Exception {
        UserProfileImpl userProfile = new UserProfileImpl(oldUserNode.getName());
        Node attrNode = null;
        try {
            attrNode = oldUserNode.getNode("jos:profile/jos:attributes");
        }
        catch (PathNotFoundException e) {
            return;
        }
        PropertyIterator props = attrNode.getProperties();
        while (props.hasNext()) {
            Property prop = props.nextProperty();
            if (prop.getName().startsWith("jcr:") || prop.getName().startsWith("exo:") || prop.getName().startsWith("jos:")) continue;
            userProfile.setAttribute(prop.getName(), prop.getString());
        }
        if (this.findUserProfileByName(userProfile.getUserName()) != null) {
            this.removeUserProfile(userProfile.getUserName(), false);
        }
        this.saveUserProfile(userProfile, false);
    }

    private void saveUserProfile(Session session, UserProfile profile, boolean broadcast) throws RepositoryException, Exception {
        Node userNode = this.utils.getUserNode(session, profile.getUserName());
        Node profileNode = this.getProfileNode(userNode);
        boolean isNewProfile = profileNode.isNew();
        if (broadcast) {
            this.preSave(profile, isNewProfile);
        }
        this.writeProfile(profile, profileNode);
        session.save();
        this.putInCache(profile);
        if (broadcast) {
            this.postSave(profile, isNewProfile);
        }
    }

    private Node getProfileNode(Node userNode) throws RepositoryException {
        try {
            return userNode.getNode("jos:profile");
        }
        catch (PathNotFoundException e) {
            return userNode.addNode("jos:profile");
        }
    }

    private UserProfile readProfile(String userName, Node profileNode) throws RepositoryException {
        UserProfile profile = this.createUserProfileInstance(userName);
        PropertyIterator attributes = profileNode.getProperties();
        while (attributes.hasNext()) {
            Property prop = attributes.nextProperty();
            if (!prop.getName().startsWith(ATTRIBUTE_PREFIX)) continue;
            String name = prop.getName().substring(ATTRIBUTE_PREFIX.length());
            String value = prop.getString();
            profile.setAttribute(name, value);
        }
        return profile;
    }

    private void writeProfile(UserProfile userProfile, Node profileNode) throws RepositoryException {
        for (Map.Entry attribute : userProfile.getUserInfoMap().entrySet()) {
            profileNode.setProperty(ATTRIBUTE_PREFIX + (String)attribute.getKey(), (String)attribute.getValue());
        }
    }

    private UserProfile getFromCache(String userName) {
        return (UserProfile)this.cache.get((Serializable)((Object)userName), CacheHandler.CacheType.USER_PROFILE);
    }

    private void putInCache(UserProfile profile) {
        this.cache.put((Serializable)((Object)profile.getUserName()), profile, CacheHandler.CacheType.USER_PROFILE);
    }

    private void removeFromCache(UserProfile profile) {
        this.cache.remove((Serializable)((Object)profile.getUserName()), CacheHandler.CacheType.USER_PROFILE);
    }

    private void preSave(UserProfile userProfile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.preSave(userProfile, isNew);
        }
    }

    private void postSave(UserProfile userProfile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.postSave(userProfile, isNew);
        }
    }

    private void preDelete(UserProfile userProfile, boolean broadcast) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.preDelete(userProfile);
        }
    }

    private void postDelete(UserProfile userProfile) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.postDelete(userProfile);
        }
    }

    public void addUserProfileEventListener(UserProfileEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.add(listener);
    }

    public void removeUserProfileEventListener(UserProfileEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.remove(listener);
    }

    public List<UserProfileEventListener> getUserProfileListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

