/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.util.Collection;
import java.util.Date;
import javax.jcr.Node;
import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceURL;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.navigation.NavigationUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.scv.UIPresentation;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.UISCVPreferences;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.gatein.portal.controller.resource.ResourceScope;
import org.json.JSONArray;
import org.json.JSONObject;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="system:/groovy/SingleContentViewer/UISingleContentView.gtmpl")
public class UISingleContentViewerPortlet
extends UIPortletApplication {
    public static String REPOSITORY = "repository";
    public static String WORKSPACE = "workspace";
    public static String IDENTIFIER = "nodeIdentifier";
    public static String DRIVE = "nodeDrive";
    public static String PARAMETER = "ParameterName";
    public static String SHOW_DATE = "ShowDate";
    public static String SHOW_TITLE = "ShowTitle";
    public static String SHOW_OPTIONBAR = "ShowOptionBar";
    public static String CONTEXTUAL_MODE = "ContextEnable";
    public static String PRINT_PARAMETER = "PrintParameterName";
    public static String PRINT_PAGE = "PrintPage";
    public static final String PREFERENCE_TARGET_PAGE = "basePath";
    public static final String PREFERENCE_SHOW_SCV_WITH = "showScvWith";
    public static final String DEFAULT_SHOW_SCV_WITH = "content-id";
    public static final String ENABLE_CACHE = "sharedCache";
    public static final String NAVIGATION_SCOPE = "NavigationScope";
    public static final String NAVIGATION_SCOPE_SINGLE = "single";
    public static final String NAVIGATION_SCOPE_CHILDREN = "children";
    public static final String NAVIGATION_SCOPE_GRAND_CHILDREN = "grandChildren";
    public static final String NAVIGATION_SCOPE_ALL = "all";
    private PortletMode mode = null;
    public static final String UIPreferencesPopupID = "UIPreferencesPopupWindows";
    private UISCVPreferences popPreferences;
    private UIPresentationContainer uiPresentation;
    PortletPreferences preferences;

    public UISingleContentViewerPortlet() throws Exception {
        this.addChild(UIPopupContainer.class, null, "UIPopupContainer-" + new Date().getTime());
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        this.preferences = portletRequestContext.getRequest().getPreferences();
    }

    public void activateMode(PortletMode newMode) throws Exception {
        if (this.getChild(UIPresentationContainer.class) != null) {
            this.removeChild(UIPresentationContainer.class);
        }
        if (this.getChild(UISCVPreferences.class) != null) {
            this.removeChild(UISCVPreferences.class);
        }
        if (PortletMode.VIEW.equals((Object)newMode)) {
            PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            this.uiPresentation = (UIPresentationContainer)this.addChild(UIPresentationContainer.class, null, UIPresentationContainer.class.getSimpleName() + pContext.getWindowId());
        } else if (PortletMode.EDIT.equals((Object)newMode)) {
            this.popPreferences = (UISCVPreferences)this.addChild(UISCVPreferences.class, null, null);
            this.popPreferences.setInternalPreferencesMode(true);
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext pContext = (PortletRequestContext)context;
        PortletMode newMode = pContext.getApplicationMode();
        PortletPreferences preferences = pContext.getRequest().getPreferences();
        Boolean sharedCache = "true".equals(preferences.getValue(ENABLE_CACHE, "true"));
        if (context.getRemoteUser() == null && !Boolean.parseBoolean(preferences.getValue(CONTEXTUAL_MODE, "false")) || Utils.isLiveMode() && sharedCache.booleanValue() && !Utils.isPortalEditMode() && Utils.isPortletViewMode((PortletRequestContext)pContext)) {
            WCMService wcmService = (WCMService)this.getApplicationComponent(WCMService.class);
            pContext.getResponse().setProperty("portlet.expiration-cache", "" + wcmService.getPortletExpirationCache());
            if (log.isTraceEnabled()) {
                log.trace((Object)("SCV rendering : cache set to " + wcmService.getPortletExpirationCache()));
            }
        }
        if (!newMode.equals((Object)this.mode)) {
            this.activateMode(newMode);
            this.mode = newMode;
        }
        Node nodeView = null;
        if (this.uiPresentation != null && (nodeView = this.uiPresentation.getNodeView()) != null) {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            ((UIPresentation)this.uiPresentation.getChild(UIPresentation.class)).setTemplatePath(templateService.getTemplatePath(nodeView, false));
        }
        if (context.getRemoteUser() != null && "Edit".equals(Utils.getCurrentMode())) {
            pContext.getJavascriptManager().loadScriptResource(ResourceScope.SHARED, "content-selector");
            pContext.getJavascriptManager().loadScriptResource(ResourceScope.SHARED, "quick-edit");
        }
        this.setId(UISingleContentViewerPortlet.class.getSimpleName() + pContext.getWindowId());
        super.processRender(app, context);
    }

    public void changeToViewMode() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        portletRequestContext.setApplicationMode(PortletMode.VIEW);
    }

    public void serveResource(WebuiRequestContext context) throws Exception {
        super.serveResource(context);
        ResourceRequest req = (ResourceRequest)context.getRequest();
        String nodeURI = req.getResourceID();
        JSONArray jsChilds = this.getChildrenAsJSON(nodeURI);
        if (jsChilds == null) {
            return;
        }
        MimeResponse res = (MimeResponse)context.getResponse();
        res.setContentType("text/json");
        res.getWriter().write(jsChilds.toString());
    }

    public JSONArray getChildrenAsJSON(String nodeURI) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Collection children = null;
        UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
        UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
        filterConfigBuilder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
        filterConfigBuilder.withTemporalCheck();
        UserNodeFilterConfig filterConfig = filterConfigBuilder.build();
        UserNavigation userNav = userPortal.getNavigation(Util.getUIPortal().getSiteKey());
        UserNode userNode = userPortal.resolvePath(userNav, filterConfig, nodeURI);
        if (userNode != null) {
            userPortal.updateNode(userNode, NavigationUtils.ECMS_NAVIGATION_SCOPE, null);
            children = userNode.getChildren();
        }
        JSONArray jsChildren = new JSONArray();
        if (children == null) {
            return null;
        }
        MimeResponse res = (MimeResponse)context.getResponse();
        for (UserNode child : children) {
            jsChildren.put((Object)this.toJSON(child, res));
        }
        return jsChildren;
    }

    private JSONObject toJSON(UserNode node, MimeResponse res) throws Exception {
        JSONObject json = new JSONObject();
        String nodeId = node.getId();
        json.put("label", (Object)node.getEncodedResolvedLabel());
        json.put("hasChild", node.getChildrenCount() > 0);
        UserNode selectedNode = Util.getUIPortal().getNavPath();
        json.put("isSelected", nodeId.equals(selectedNode.getId()));
        json.put("icon", (Object)node.getIcon());
        String nodeURI = "";
        if (node.getPageRef() != null) {
            nodeURI = node.getURI();
        }
        json.put("uri", (Object)nodeURI);
        ResourceURL rsURL = res.createResourceURL();
        rsURL.setResourceID(res.encodeURL(node.getURI()));
        json.put("getNodeURL", (Object)rsURL.toString());
        JSONArray jsonChildren = new JSONArray();
        for (UserNode child : node.getChildren()) {
            jsonChildren.put((Object)this.toJSON(child, res));
        }
        json.put("childs", (Object)jsonChildren);
        return json;
    }

    public String getNavigationScope() throws Exception {
        PortletPreferences preferences = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
        String navigationScope = preferences.getValue(NAVIGATION_SCOPE, NAVIGATION_SCOPE_CHILDREN);
        return navigationScope;
    }

    public String getNavigation() throws Exception {
        String userName = ConversationState.getCurrent().getIdentity().getUserId();
        String portalName = Util.getPortalRequestContext().getPortalOwner();
        PortletPreferences preferences = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
        String navigationScope = preferences.getValue(NAVIGATION_SCOPE, NAVIGATION_SCOPE_CHILDREN);
        Scope scope = Scope.CHILDREN;
        switch (navigationScope) {
            case "single": {
                scope = Scope.SINGLE;
                break;
            }
            case "children": {
                scope = Scope.CHILDREN;
                break;
            }
            case "grandChildren": {
                scope = Scope.GRANDCHILDREN;
                break;
            }
            case "all": {
                scope = Scope.ALL;
            }
        }
        return NavigationUtils.getNavigationAsJSON((String)portalName, (String)userName, (Scope)scope, (String)navigationScope);
    }
}

