/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.concurrent;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleReplicatedExoCache<K extends Serializable, V extends Serializable>
extends ConcurrentFIFOExoCache<K, V> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.cache.SimpleReplicatedExoCache");
    private final RPCService rpcService;
    private RemoteCommand command;
    private final String id;
    private final String ctxName;

    public SimpleReplicatedExoCache() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.rpcService = (RPCService)container.getComponentInstanceOfType(RPCService.class);
        if (this.rpcService == null) {
            throw new IllegalArgumentException("The RPCService is required for this type of cache, please configure it first");
        }
        this.ctxName = container.getContext().getName();
        this.id = UUID.randomUUID().toString();
    }

    SimpleReplicatedExoCache(ExoContainerContext ctx, RPCService rpcService) {
        if (rpcService == null) {
            throw new IllegalArgumentException("The RPCService is required for this type of cache, please configure it first");
        }
        this.rpcService = rpcService;
        this.ctxName = ctx.getName();
        this.id = UUID.randomUUID().toString();
    }

    @Override
    public void setName(String s) {
        super.setName(s);
        if (this.command == null) {
            this.command = this.rpcService.registerCommand(new RemoteCommand(){
                private final String commandId;
                {
                    this.commandId = SimpleReplicatedExoCache.class.getName() + "-" + SimpleReplicatedExoCache.this.getName() + "-" + SimpleReplicatedExoCache.this.ctxName;
                }

                public String getId() {
                    return this.commandId;
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    if (!SimpleReplicatedExoCache.this.id.equals(args[0])) {
                        if ("c".equals(args[1])) {
                            try {
                                SimpleReplicatedExoCache.this.clearCacheOnly();
                            }
                            catch (Exception e) {
                                LOG.warn((Object)"Could not clear the cache on other cluster nodes", (Throwable)e);
                            }
                        } else if ("r".equals(args[1])) {
                            try {
                                SimpleReplicatedExoCache.this.removeOnly(args[2]);
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("Could not remove the entry " + args[2] + " on other cluster nodes"), (Throwable)e);
                            }
                        } else if ("p".equals(args[1])) {
                            try {
                                SimpleReplicatedExoCache.this.putIfNeeded(args[2], args[3]);
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("Could not put the entry " + args[2] + " on other cluster nodes"), (Throwable)e);
                            }
                        } else if ("m".equals(args[1])) {
                            try {
                                Map objs = (Map)((Object)args[2]);
                                for (Map.Entry entry : objs.entrySet()) {
                                    SimpleReplicatedExoCache.this.putIfNeeded((Serializable)entry.getKey(), (Serializable)entry.getValue());
                                }
                            }
                            catch (Exception e) {
                                LOG.warn((Object)"Could not put entries on other cluster nodes", (Throwable)e);
                            }
                        }
                    }
                    return Boolean.valueOf(true);
                }
            });
        }
    }

    void removeOnly(Serializable name) {
        super.remove(name);
    }

    void clearCacheOnly() {
        super.clearCache();
    }

    void putIfNeeded(K name, V obj) {
        Serializable currrentValue = (Serializable)this.get((Serializable)name);
        if (currrentValue == null || !currrentValue.equals(obj)) {
            super.put(name, obj);
        }
    }

    @Override
    public V remove(Serializable name) {
        Serializable v = (Serializable)super.remove(name);
        if (v != null) {
            try {
                this.rpcService.executeCommandOnAllNodes(this.command, false, new Serializable[]{this.id, "r", name});
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not remove the entry " + name + " on other cluster nodes"), (Throwable)e);
            }
        }
        return (V)v;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        try {
            this.rpcService.executeCommandOnAllNodes(this.command, false, new Serializable[]{this.id, "c"});
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not clear the cache on other cluster nodes", (Throwable)e);
        }
    }

    @Override
    public void put(K name, V obj) {
        super.put(name, obj);
        try {
            this.rpcService.executeCommandOnAllNodes(this.command, false, new Serializable[]{this.id, "p", name, obj});
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not put the entry " + name + " on other cluster nodes"), (Throwable)e);
        }
    }

    @Override
    public void putMap(Map<? extends K, ? extends V> objs) {
        super.putMap(objs);
        try {
            this.rpcService.executeCommandOnAllNodes(this.command, false, new Serializable[]{this.id, "m", new HashMap<K, V>(objs)});
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not put entries on other cluster nodes", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.command != null) {
                this.rpcService.unregisterCommand(this.command);
            }
        }
        finally {
            super.finalize();
        }
    }
}

