/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.Collection;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.navigation.NavigationData;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.pom.config.POMSession;
import org.gatein.mop.api.workspace.Navigation;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;

abstract class DataCache {
    DataCache() {
    }

    protected abstract void removeNodes(Collection<String> var1);

    protected abstract NodeData getNode(POMSession var1, String var2);

    protected abstract NavigationData getNavigation(POMSession var1, SiteKey var2);

    protected abstract void removeNavigation(SiteKey var1);

    protected abstract void clear();

    final NodeData getNodeData(POMSession session, String nodeId) {
        NodeData data = session.isModified() ? this.loadNode(session, nodeId) : this.getNode(session, nodeId);
        return data;
    }

    final NavigationData getNavigationData(POMSession session, SiteKey key) {
        NavigationData data = session.isModified() ? this.loadNavigation(session, key) : this.getNavigation(session, key);
        return data;
    }

    final void removeNodeData(POMSession session, Collection<String> ids) {
        this.removeNodes(ids);
    }

    final void removeNavigationData(POMSession session, SiteKey key) {
        this.removeNavigation(key);
    }

    protected final NodeData loadNode(POMSession session, String nodeId) {
        Navigation navigation = (Navigation)session.findObjectById(ObjectType.NAVIGATION, nodeId);
        if (navigation != null) {
            return new NodeData(navigation);
        }
        return null;
    }

    protected final NavigationData loadNavigation(POMSession session, SiteKey key) {
        ObjectType<Site> objectType;
        Workspace workspace = session.getWorkspace();
        Site site = workspace.getSite(objectType = Utils.objectType(key.getType()), key.getName());
        if (site != null) {
            Navigation defaultNavigation = site.getRootNavigation().getChild("default");
            if (defaultNavigation != null) {
                return new NavigationData(key, defaultNavigation);
            }
            return NavigationData.EMPTY;
        }
        return NavigationData.EMPTY;
    }
}

