/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.names;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import thredds.util.HttpUriResolver;
import thredds.util.HttpUriResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CatalogNamespace {
    CATALOG_1_0("", "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "/resources/thredds/schemas/InvCatalog.1.0.2.xsd", "http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.1.0.2.xsd"),
    CATALOG_0_6("oldThredds", "http://www.unidata.ucar.edu/thredds", "/resources/thredds/schemas/InvCatalog.0.6.xsd", "http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.0.6.xsd"),
    XLINK("xlink", "http://www.w3.org/1999/xlink", "/resources/thredds/schemas/xlink.xsd", "");

    private String standardPrefix;
    private String namespaceUri;
    private String schemaLocalResourceName;
    private URI schemaRemoteResourceUri;

    public static CatalogNamespace getNamespace(String namespaceUri) {
        if (namespaceUri == null) {
            return null;
        }
        for (CatalogNamespace curNs : CatalogNamespace.values()) {
            if (!curNs.namespaceUri.equals(namespaceUri)) continue;
            return curNs;
        }
        return null;
    }

    private CatalogNamespace(String standardPrefix, String namespaceUri, String schemaLocalResourceName, String schemaRemoteResourceUri) {
        if (namespaceUri == null) {
            throw new IllegalArgumentException("The XML Namespace URI may not be null.");
        }
        if (schemaRemoteResourceUri == null) {
            throw new IllegalArgumentException("The remote resourc URL for the XML Schema may not be null.");
        }
        this.standardPrefix = standardPrefix;
        this.namespaceUri = namespaceUri;
        this.schemaLocalResourceName = schemaLocalResourceName;
        try {
            this.schemaRemoteResourceUri = new URI(schemaRemoteResourceUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Badly formed resource URI [" + schemaRemoteResourceUri + "].", e);
        }
    }

    public String getStandardPrefix() {
        return this.standardPrefix;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getSchemaLocalResourceName() {
        return this.schemaLocalResourceName;
    }

    public URI getSchemaRemoteResourceUri() {
        return this.schemaRemoteResourceUri;
    }

    public InputStream getSchemaAsInputStream() throws IOException {
        InputStream inStream = null;
        if (this.getSchemaLocalResourceName() != null) {
            inStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getSchemaLocalResourceName());
        }
        if (inStream == null && this.getSchemaRemoteResourceUri() != null) {
            HttpUriResolver httpUriResolver = HttpUriResolverFactory.getDefaultHttpUriResolver(this.getSchemaRemoteResourceUri());
            httpUriResolver.makeRequest();
            inStream = httpUriResolver.getResponseBodyAsInputStream();
        }
        return inStream;
    }

    public Schema getSchema() throws IOException, SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource source = new StreamSource(this.getSchemaAsInputStream());
        source.setSystemId(this.getSchemaRemoteResourceUri().toString());
        return schemaFactory.newSchema(source);
    }
}

