/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.activity;

import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.common.InitParamsValue;
import org.exoplatform.forum.ext.activity.ActivityExecutor;
import org.exoplatform.forum.ext.activity.ActivityTask;
import org.exoplatform.forum.ext.activity.ForumActivityContext;
import org.exoplatform.forum.ext.activity.ForumActivityUtils;
import org.exoplatform.forum.ext.activity.PostActivityTask;
import org.exoplatform.forum.ext.activity.TopicActivityTask;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.idm.PicketLinkIDMServiceImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.hibernate.TransactionException;
import org.picocontainer.Startable;

public class ForumTaskManager
implements Startable {
    private static final Log LOG = ExoLogger.getExoLogger(ForumTaskManager.class);
    private static final String PERIOD_TIME_KEY = "periodTime";
    private static final String MAX_PERSIST_SIZE = "maxPersistSize";
    private static final String PRIORITY_KEY = "thread-priority";
    private static final String ASYNC_EXECUTION_KEY = "async-execution";
    private ScheduledExecutorService scheduler;
    private Queue<Task<ForumActivityContext>> tasks = null;
    private static long INTERVAL = 5000L;
    private static int MAX_SIZE_PERSIST = 25;
    private static int THREAD_PRIORITY = 1;
    private boolean isDone = true;
    private boolean forceStop = false;
    private boolean isAsync = true;

    public ForumTaskManager(InitParams params) {
        INTERVAL = InitParamsValue.getLong((InitParams)params, (String)PERIOD_TIME_KEY, (long)INTERVAL);
        MAX_SIZE_PERSIST = InitParamsValue.getInteger((InitParams)params, (String)MAX_PERSIST_SIZE, (int)MAX_SIZE_PERSIST);
        THREAD_PRIORITY = InitParamsValue.getInteger((InitParams)params, (String)PRIORITY_KEY, (int)THREAD_PRIORITY);
        THREAD_PRIORITY = InitParamsValue.getInteger((InitParams)params, (String)PRIORITY_KEY, (int)THREAD_PRIORITY);
        this.isAsync = InitParamsValue.getBoolean((InitParams)params, (String)ASYNC_EXECUTION_KEY, (boolean)true);
    }

    public void start() {
        if (this.isAsync) {
            this.makeInterval();
        }
    }

    public void stop() {
        this.isDone = false;
        this.forceStop = true;
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        this.scheduler = null;
    }

    private void makeInterval() {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "Forum-task-manager-thread");
                t.setPriority(THREAD_PRIORITY);
                return t;
            }
        };
        this.scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (ForumTaskManager.this.isCommit(true)) {
                    ForumTaskManager.this.commit();
                }
            }
        }, 30000L, INTERVAL, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean commit() {
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            this.persist();
        }
        finally {
            PicketLinkIDMServiceImpl idmServiceImpl = (PicketLinkIDMServiceImpl)CommonsUtils.getService(PicketLinkIDMServiceImpl.class);
            if (idmServiceImpl != null) {
                try {
                    if (idmServiceImpl.getIdentitySession().getTransaction().isActive()) {
                        idmServiceImpl.getIdentitySession().getTransaction().commit();
                    }
                }
                catch (TransactionException e) {
                    LOG.debug((Object)"The PoolingConnection is null ", (Throwable)e);
                }
                catch (Exception e) {
                    LOG.debug((Object)"End request life cycle unsuccessfully ", (Throwable)e);
                }
            }
            RequestLifeCycle.end();
        }
        return true;
    }

    public void addTask(Task<ForumActivityContext> task) {
        if (this.tasks == null) {
            this.tasks = new LinkedBlockingQueue<Task<ForumActivityContext>>();
        }
        this.tasks.add(task);
        if (!this.isAsync) {
            this.persist();
        }
        if (this.isCommit(false)) {
            this.scheduler.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ForumTaskManager.this.commit();
                }
            });
        }
    }

    private boolean isCommit(boolean forceCommit) {
        if (this.tasks == null || this.forceStop) {
            return false;
        }
        return this.isDone && (forceCommit || this.tasks.size() >= MAX_SIZE_PERSIST);
    }

    private Queue<Task<ForumActivityContext>> popTasks() {
        Queue<Task<ForumActivityContext>> tmp = this.tasks;
        this.tasks = null;
        LinkedBlockingQueue<Task<ForumActivityContext>> processTasks = new LinkedBlockingQueue<Task<ForumActivityContext>>();
        for (Task task : tmp) {
            if (processTasks.contains(task)) continue;
            processTasks.add(task);
        }
        return processTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist() {
        this.isDone = false;
        try {
            Task<ForumActivityContext> task;
            Queue<Task<ForumActivityContext>> tasks = this.popTasks();
            while (!this.forceStop && (task = tasks.poll()) != null) {
                ConversationState lastState = ConversationState.getCurrent();
                try {
                    this.startProcess(task);
                    this.processTask(task);
                }
                finally {
                    this.endProcess(task, lastState);
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Running task of forum activity unsuccessful.", (Throwable)e);
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.isDone = true;
        }
    }

    private void startProcess(Task<ForumActivityContext> task) {
        try {
            ConversationState.setCurrent((ConversationState)task.getState());
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to set state context for forum activity task", (Throwable)e);
        }
    }

    private void processTask(Task<ForumActivityContext> task) {
        ActivityTask<ForumActivityContext> activityTask = task.getTask();
        ExoSocialActivity got = ActivityExecutor.execute(activityTask, task.getContext());
        if (activityTask instanceof PostActivityTask) {
            PostActivityTask task_ = PostActivityTask.ADD_POST;
            if (got != null && activityTask.equals(task_)) {
                ForumActivityUtils.takeCommentBack(task.getContext().getPost(), got);
            }
        } else if (activityTask instanceof TopicActivityTask) {
            TopicActivityTask task_ = TopicActivityTask.ADD_TOPIC;
            if (got != null && activityTask.equals(task_)) {
                ForumActivityUtils.takeActivityBack(task.getContext().getTopic(), got);
            }
        }
    }

    private void endProcess(Task<ForumActivityContext> task, ConversationState lastState) {
        try {
            ConversationState.setCurrent((ConversationState)lastState);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to reset state context for forum activity task executing", (Throwable)e);
        }
    }

    public static class Task<T> {
        private ForumActivityContext ctx;
        private ActivityTask<T> task;
        private final ConversationState state;

        public Task(ForumActivityContext ctx, ActivityTask<T> task) {
            this.ctx = ctx;
            this.task = task;
            this.state = ConversationState.getCurrent();
        }

        public ForumActivityContext getContext() {
            return this.ctx;
        }

        public ActivityTask<T> getTask() {
            return this.task;
        }

        public ConversationState getState() {
            return this.state;
        }
    }
}

