/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.InstanceObjectType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class FunctionType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private ArrowType call;
    private ObjectType.Property prototypeSlot;
    private final Kind kind;
    private ObjectType typeOfThis;
    private Node source;
    private List<ObjectType> implementedInterfaces = ImmutableList.of();
    private List<ObjectType> extendedInterfaces = ImmutableList.of();
    private List<FunctionType> subTypes;
    private String templateTypeName;

    FunctionType(JSTypeRegistry registry, String name, Node source, ArrowType arrowType, ObjectType typeOfThis, String templateTypeName, boolean isConstructor, boolean nativeType) {
        super(registry, name, registry.getNativeObjectType(JSTypeNative.FUNCTION_INSTANCE_TYPE), nativeType);
        this.setPrettyPrint(true);
        Preconditions.checkArgument((source == null || 105 == source.getType() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)arrowType);
        this.source = source;
        Kind kind = this.kind = isConstructor ? Kind.CONSTRUCTOR : Kind.ORDINARY;
        this.typeOfThis = isConstructor ? (typeOfThis != null ? typeOfThis : new InstanceObjectType(registry, this, nativeType)) : (typeOfThis != null ? typeOfThis : registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE));
        this.call = arrowType;
        this.templateTypeName = templateTypeName;
    }

    private FunctionType(JSTypeRegistry registry, String name, Node source) {
        super(registry, name, registry.getNativeObjectType(JSTypeNative.FUNCTION_INSTANCE_TYPE));
        this.setPrettyPrint(true);
        Preconditions.checkArgument((source == null || 105 == source.getType() ? 1 : 0) != 0);
        Preconditions.checkArgument((name != null ? 1 : 0) != 0);
        this.source = source;
        this.call = new ArrowType(registry, new Node(83), null);
        this.kind = Kind.INTERFACE;
        this.typeOfThis = new InstanceObjectType(registry, this);
    }

    static FunctionType forInterface(JSTypeRegistry registry, String name, Node source) {
        return new FunctionType(registry, name, source);
    }

    @Override
    public boolean isInstanceType() {
        return this.isEquivalentTo(this.registry.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE));
    }

    @Override
    public boolean isConstructor() {
        return this.kind == Kind.CONSTRUCTOR;
    }

    @Override
    public boolean isInterface() {
        return this.kind == Kind.INTERFACE;
    }

    @Override
    public boolean isOrdinaryFunction() {
        return this.kind == Kind.ORDINARY;
    }

    @Override
    public FunctionType toMaybeFunctionType() {
        return this;
    }

    @Override
    public boolean canBeCalled() {
        return true;
    }

    public boolean hasImplementedInterfaces() {
        FunctionType superCtor;
        if (!this.implementedInterfaces.isEmpty()) {
            return true;
        }
        FunctionType functionType = superCtor = this.isConstructor() ? this.getSuperClassConstructor() : null;
        if (superCtor != null) {
            return superCtor.hasImplementedInterfaces();
        }
        return false;
    }

    public Iterable<Node> getParameters() {
        Node n = this.getParametersNode();
        if (n != null) {
            return n.children();
        }
        return Collections.emptySet();
    }

    public Node getParametersNode() {
        return this.call.parameters;
    }

    public int getMinArguments() {
        int i = 0;
        int min = 0;
        for (Node n : this.getParameters()) {
            ++i;
            if (n.isOptionalArg() || n.isVarArgs()) continue;
            min = i;
        }
        return min;
    }

    public int getMaxArguments() {
        Node lastParam;
        Node params = this.getParametersNode();
        if (!(params == null || (lastParam = params.getLastChild()) != null && lastParam.isVarArgs())) {
            return params.getChildCount();
        }
        return Integer.MAX_VALUE;
    }

    public JSType getReturnType() {
        return this.call.returnType;
    }

    public boolean isReturnTypeInferred() {
        return this.call.returnTypeInferred;
    }

    ArrowType getInternalArrowType() {
        return this.call;
    }

    @Override
    public ObjectType.Property getSlot(String name) {
        if ("prototype".equals(name)) {
            this.getPrototype();
            return this.prototypeSlot;
        }
        return super.getSlot(name);
    }

    @Override
    public Set<String> getOwnPropertyNames() {
        if (this.prototypeSlot == null) {
            return super.getOwnPropertyNames();
        }
        HashSet names = Sets.newHashSet((Object[])new String[]{"prototype"});
        names.addAll(super.getOwnPropertyNames());
        return names;
    }

    public ObjectType getPrototype() {
        if (this.prototypeSlot == null) {
            this.setPrototype(new PrototypeObjectType(this.registry, this.getReferenceName() + ".prototype", this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE), this.isNativeObjectType()), null);
        }
        return (ObjectType)this.prototypeSlot.getType();
    }

    public void setPrototypeBasedOn(ObjectType baseType) {
        this.setPrototypeBasedOn(baseType, null);
    }

    void setPrototypeBasedOn(ObjectType baseType, Node propertyNode) {
        if (baseType.hasReferenceName() || this.isNativeObjectType() || baseType.isFunctionPrototypeType() || !(baseType instanceof PrototypeObjectType)) {
            baseType = new PrototypeObjectType(this.registry, this.getReferenceName() + ".prototype", baseType);
        }
        this.setPrototype((PrototypeObjectType)baseType, propertyNode);
    }

    boolean setPrototype(PrototypeObjectType prototype, Node propertyNode) {
        if (prototype == null) {
            return false;
        }
        if (this.isConstructor() && prototype == this.getInstanceType()) {
            return false;
        }
        PrototypeObjectType oldPrototype = this.prototypeSlot == null ? null : (PrototypeObjectType)this.prototypeSlot.getType();
        boolean replacedPrototype = oldPrototype != null;
        this.prototypeSlot = new ObjectType.Property("prototype", prototype, true, propertyNode == null ? this.source : propertyNode);
        prototype.setOwnerFunction(this);
        if (oldPrototype != null) {
            oldPrototype.setOwnerFunction(null);
        }
        if (this.isConstructor() || this.isInterface()) {
            FunctionType superClass = this.getSuperClassConstructor();
            if (superClass != null) {
                superClass.addSubType(this);
            }
            if (this.isInterface()) {
                for (ObjectType interfaceType : this.getExtendedInterfaces()) {
                    if (interfaceType.getConstructor() == null) continue;
                    interfaceType.getConstructor().addSubType(this);
                }
            }
        }
        if (replacedPrototype) {
            this.clearCachedValues();
        }
        return true;
    }

    public Iterable<ObjectType> getAllImplementedInterfaces() {
        LinkedHashSet interfaces = Sets.newLinkedHashSet();
        for (ObjectType type : this.getImplementedInterfaces()) {
            this.addRelatedInterfaces(type, interfaces);
        }
        return interfaces;
    }

    private void addRelatedInterfaces(ObjectType instance, Set<ObjectType> set) {
        FunctionType constructor = instance.getConstructor();
        if (constructor != null) {
            if (!constructor.isInterface()) {
                return;
            }
            set.add(instance);
            for (ObjectType interfaceType : instance.getCtorExtendedInterfaces()) {
                this.addRelatedInterfaces(interfaceType, set);
            }
        }
    }

    public Iterable<ObjectType> getImplementedInterfaces() {
        FunctionType superCtor;
        FunctionType functionType = superCtor = this.isConstructor() ? this.getSuperClassConstructor() : null;
        if (superCtor == null) {
            return this.implementedInterfaces;
        }
        return Iterables.concat(this.implementedInterfaces, superCtor.getImplementedInterfaces());
    }

    public void setImplementedInterfaces(List<ObjectType> implementedInterfaces) {
        for (ObjectType type : implementedInterfaces) {
            this.registry.registerTypeImplementingInterface(this, type);
        }
        this.implementedInterfaces = ImmutableList.copyOf(implementedInterfaces);
    }

    public Iterable<ObjectType> getAllExtendedInterfaces() {
        LinkedHashSet extendedInterfaces = Sets.newLinkedHashSet();
        for (ObjectType interfaceType : this.getExtendedInterfaces()) {
            this.addRelatedExtendedInterfaces(interfaceType, extendedInterfaces);
        }
        return extendedInterfaces;
    }

    private void addRelatedExtendedInterfaces(ObjectType instance, Set<ObjectType> set) {
        FunctionType constructor = instance.getConstructor();
        if (constructor != null) {
            set.add(instance);
            for (ObjectType interfaceType : constructor.getExtendedInterfaces()) {
                this.addRelatedExtendedInterfaces(interfaceType, set);
            }
        }
    }

    public Iterable<ObjectType> getExtendedInterfaces() {
        return this.extendedInterfaces;
    }

    public int getExtendedInterfacesCount() {
        return this.extendedInterfaces.size();
    }

    public void setExtendedInterfaces(List<ObjectType> extendedInterfaces) throws UnsupportedOperationException {
        if (!this.isInterface()) {
            throw new UnsupportedOperationException();
        }
        this.extendedInterfaces = ImmutableList.copyOf(extendedInterfaces);
    }

    @Override
    public JSType getPropertyType(String name) {
        if (!this.hasOwnProperty(name)) {
            if ("call".equals(name)) {
                Node params = this.getParametersNode();
                if (params == null) {
                    this.defineDeclaredProperty(name, new FunctionBuilder(this.registry).withReturnType(this.getReturnType()).build(), this.source);
                } else {
                    params = params.cloneTree();
                    Node thisTypeNode = Node.newString(38, "thisType");
                    thisTypeNode.setJSType(this.registry.createOptionalNullableType(this.getTypeOfThis()));
                    params.addChildToFront(thisTypeNode);
                    thisTypeNode.setOptionalArg(true);
                    this.defineDeclaredProperty(name, new FunctionBuilder(this.registry).withParamsNode(params).withReturnType(this.getReturnType()).build(), this.source);
                }
            } else if ("apply".equals(name)) {
                FunctionParamBuilder builder = new FunctionParamBuilder(this.registry);
                builder.addOptionalParams(this.registry.createNullableType(this.getTypeOfThis()), this.registry.createNullableType(this.registry.getNativeType(JSTypeNative.OBJECT_TYPE)));
                this.defineDeclaredProperty(name, new FunctionBuilder(this.registry).withParams(builder).withReturnType(this.getReturnType()).build(), this.source);
            }
        }
        return super.getPropertyType(name);
    }

    @Override
    boolean defineProperty(String name, JSType type, boolean inferred, Node propertyNode) {
        if ("prototype".equals(name)) {
            ObjectType objType = type.toObjectType();
            if (objType != null) {
                if (this.prototypeSlot != null && objType.isEquivalentTo(this.prototypeSlot.getType())) {
                    return true;
                }
                this.setPrototypeBasedOn(objType, propertyNode);
                return true;
            }
            return false;
        }
        return super.defineProperty(name, type, inferred, propertyNode);
    }

    FunctionType supAndInfHelper(FunctionType that, boolean leastSuper) {
        JSType functionInstance;
        Preconditions.checkNotNull((Object)that);
        if (this.isEquivalentTo(that)) {
            return this;
        }
        if (this.isOrdinaryFunction() && that.isOrdinaryFunction() && !this.call.hasUnknownParamsOrReturn() && !that.call.hasUnknownParamsOrReturn()) {
            boolean isSubtypeOfThat = this.isSubtype(that);
            boolean isSubtypeOfThis = that.isSubtype(this);
            if (isSubtypeOfThat && !isSubtypeOfThis) {
                return leastSuper ? that : this;
            }
            if (isSubtypeOfThis && !isSubtypeOfThat) {
                return leastSuper ? this : that;
            }
            FunctionType merged = this.tryMergeFunctionPiecewise(that, leastSuper);
            if (merged != null) {
                return merged;
            }
        }
        if ((functionInstance = this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE)).isEquivalentTo(that)) {
            return leastSuper ? that : this;
        }
        if (functionInstance.isEquivalentTo(this)) {
            return leastSuper ? this : that;
        }
        FunctionType greatestFn = this.registry.getNativeFunctionType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
        FunctionType leastFn = this.registry.getNativeFunctionType(JSTypeNative.LEAST_FUNCTION_TYPE);
        return leastSuper ? greatestFn : leastFn;
    }

    private FunctionType tryMergeFunctionPiecewise(FunctionType other, boolean leastSuper) {
        Node newParamsNode = null;
        if (!this.call.hasEqualParameters(other.call)) {
            return null;
        }
        newParamsNode = this.call.parameters;
        JSType newReturnType = leastSuper ? this.call.returnType.getLeastSupertype(other.call.returnType) : this.call.returnType.getGreatestSubtype(other.call.returnType);
        ObjectType newTypeOfThis = null;
        if (FunctionType.isEquivalent(this.typeOfThis, other.typeOfThis)) {
            newTypeOfThis = this.typeOfThis;
        } else {
            JSType maybeNewTypeOfThis;
            JSType jSType = maybeNewTypeOfThis = leastSuper ? this.typeOfThis.getLeastSupertype(other.typeOfThis) : this.typeOfThis.getGreatestSubtype(other.typeOfThis);
            newTypeOfThis = maybeNewTypeOfThis instanceof ObjectType ? (ObjectType)maybeNewTypeOfThis : (leastSuper ? this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE) : this.registry.getNativeObjectType(JSTypeNative.NO_OBJECT_TYPE));
        }
        boolean newReturnTypeInferred = this.call.returnTypeInferred || other.call.returnTypeInferred;
        return new FunctionType(this.registry, null, null, new ArrowType(this.registry, newParamsNode, newReturnType, newReturnTypeInferred), newTypeOfThis, null, false, false);
    }

    public FunctionType getSuperClassConstructor() {
        Preconditions.checkArgument((this.isConstructor() || this.isInterface() ? 1 : 0) != 0);
        ObjectType maybeSuperInstanceType = this.getPrototype().getImplicitPrototype();
        if (maybeSuperInstanceType == null) {
            return null;
        }
        return maybeSuperInstanceType.getConstructor();
    }

    public static ObjectType getTopDefiningInterface(ObjectType type, String propertyName) {
        ObjectType foundType = null;
        if (type.hasProperty(propertyName)) {
            foundType = type;
        }
        for (ObjectType interfaceType : type.getCtorExtendedInterfaces()) {
            if (!interfaceType.hasProperty(propertyName)) continue;
            foundType = FunctionType.getTopDefiningInterface(interfaceType, propertyName);
        }
        return foundType;
    }

    public ObjectType getTopMostDefiningType(String propertyName) {
        Preconditions.checkState((this.isConstructor() || this.isInterface() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.getPrototype().hasProperty(propertyName));
        FunctionType ctor = this;
        if (this.isInterface()) {
            return FunctionType.getTopDefiningInterface(this.getInstanceType(), propertyName);
        }
        ObjectType topInstanceType = ctor.getInstanceType();
        do {
            topInstanceType = ctor.getInstanceType();
        } while ((ctor = ctor.getSuperClassConstructor()) != null && ctor.getPrototype().hasProperty(propertyName));
        return topInstanceType;
    }

    @Override
    public boolean isEquivalentTo(JSType otherType) {
        FunctionType that = JSType.toMaybeFunctionType(otherType);
        if (that == null) {
            return false;
        }
        if (this.isConstructor()) {
            if (that.isConstructor()) {
                return this == that;
            }
            return false;
        }
        if (this.isInterface()) {
            if (that.isInterface()) {
                return this.getReferenceName().equals(that.getReferenceName());
            }
            return false;
        }
        if (that.isInterface()) {
            return false;
        }
        return this.typeOfThis.isEquivalentTo(that.typeOfThis) && this.call.isEquivalentTo(that.call);
    }

    @Override
    public int hashCode() {
        return this.isInterface() ? this.getReferenceName().hashCode() : this.call.hashCode();
    }

    public boolean hasEqualCallType(FunctionType otherType) {
        return this.call.isEquivalentTo(otherType.call);
    }

    @Override
    public String toString() {
        boolean hasKnownTypeOfThis;
        if (!this.isPrettyPrint() || this == this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE)) {
            return "Function";
        }
        this.setPrettyPrint(false);
        StringBuilder b = new StringBuilder(32);
        b.append("function (");
        int paramNum = this.call.parameters.getChildCount();
        boolean bl = hasKnownTypeOfThis = !this.typeOfThis.isUnknownType();
        if (hasKnownTypeOfThis) {
            if (this.isConstructor()) {
                b.append("new:");
            } else {
                b.append("this:");
            }
            b.append(this.typeOfThis.toString());
        }
        if (paramNum > 0) {
            Node p;
            if (hasKnownTypeOfThis) {
                b.append(", ");
            }
            if ((p = this.call.parameters.getFirstChild()).isVarArgs()) {
                this.appendVarArgsString(b, p.getJSType());
            } else {
                b.append(p.getJSType().toString());
            }
            for (p = p.getNext(); p != null; p = p.getNext()) {
                b.append(", ");
                if (p.isVarArgs()) {
                    this.appendVarArgsString(b, p.getJSType());
                    continue;
                }
                b.append(p.getJSType().toString());
            }
        }
        b.append("): ");
        b.append(this.call.returnType);
        this.setPrettyPrint(true);
        return b.toString();
    }

    private void appendVarArgsString(StringBuilder builder, JSType paramType) {
        if (paramType.isUnionType()) {
            paramType = paramType.toMaybeUnionType().getRestrictedUnion(this.registry.getNativeType(JSTypeNative.VOID_TYPE));
        }
        builder.append("...[").append(paramType.toString()).append("]");
    }

    @Override
    public boolean isSubtype(JSType that) {
        if (JSType.isSubtypeHelper(this, that)) {
            return true;
        }
        if (that.isFunctionType()) {
            FunctionType other = that.toMaybeFunctionType();
            if (other.isInterface()) {
                return true;
            }
            if (this.isInterface()) {
                return false;
            }
            boolean treatThisTypesAsCovariant = this.isConstructor() || other.isConstructor() || other.typeOfThis.getConstructor() != null && other.typeOfThis.getConstructor().isInterface() || other.typeOfThis.isSubtype(this.typeOfThis) || this.typeOfThis.isSubtype(other.typeOfThis);
            return treatThisTypesAsCovariant && this.call.isSubtype(other.call);
        }
        return this.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE).isSubtype(that);
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseFunctionType(this);
    }

    public ObjectType getInstanceType() {
        Preconditions.checkState((boolean)this.hasInstanceType());
        return this.typeOfThis;
    }

    void setInstanceType(ObjectType instanceType) {
        this.typeOfThis = instanceType;
    }

    public boolean hasInstanceType() {
        return this.isConstructor() || this.isInterface();
    }

    @Override
    public ObjectType getTypeOfThis() {
        return this.typeOfThis.isNoObjectType() ? this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE) : this.typeOfThis;
    }

    public Node getSource() {
        return this.source;
    }

    public void setSource(Node source) {
        if (this.prototypeSlot != null && (source == null || this.prototypeSlot.getNode() == null)) {
            this.prototypeSlot = new ObjectType.Property(this.prototypeSlot.getName(), this.prototypeSlot.getType(), this.prototypeSlot.isTypeInferred(), source);
        }
        this.source = source;
    }

    private void addSubType(FunctionType subType) {
        if (this.subTypes == null) {
            this.subTypes = Lists.newArrayList();
        }
        this.subTypes.add(subType);
    }

    @Override
    public void clearCachedValues() {
        super.clearCachedValues();
        if (this.subTypes != null) {
            for (FunctionType subType : this.subTypes) {
                subType.clearCachedValues();
            }
        }
        if (!this.isNativeObjectType()) {
            if (this.hasInstanceType()) {
                this.getInstanceType().clearCachedValues();
            }
            if (this.prototypeSlot != null) {
                ((PrototypeObjectType)this.prototypeSlot.getType()).clearCachedValues();
            }
        }
    }

    public List<FunctionType> getSubTypes() {
        return this.subTypes;
    }

    @Override
    public boolean hasCachedValues() {
        return this.prototypeSlot != null || super.hasCachedValues();
    }

    public String getTemplateTypeName() {
        return this.templateTypeName;
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticScope<JSType> scope) {
        JSType maybeTypeOfThis;
        this.setResolvedTypeInternal(this);
        this.call = (ArrowType)FunctionType.safeResolve(this.call, t, scope);
        if (this.prototypeSlot != null) {
            this.prototypeSlot.setType(FunctionType.safeResolve(this.prototypeSlot.getType(), t, scope));
        }
        if ((maybeTypeOfThis = FunctionType.safeResolve(this.typeOfThis, t, scope)) != null) {
            maybeTypeOfThis = maybeTypeOfThis.restrictByNotNullOrUndefined();
        }
        if (maybeTypeOfThis instanceof ObjectType) {
            this.typeOfThis = (ObjectType)maybeTypeOfThis;
        }
        boolean changed = false;
        ImmutableList.Builder resolvedInterfaces = ImmutableList.builder();
        for (ObjectType iface : this.implementedInterfaces) {
            ObjectType resolvedIface = (ObjectType)iface.resolve(t, scope);
            resolvedInterfaces.add((Object)resolvedIface);
            changed |= resolvedIface != iface;
        }
        if (changed) {
            this.implementedInterfaces = resolvedInterfaces.build();
        }
        if (this.subTypes != null) {
            for (int i = 0; i < this.subTypes.size(); ++i) {
                this.subTypes.set(i, JSType.toMaybeFunctionType(this.subTypes.get(i).resolve(t, scope)));
            }
        }
        return super.resolveInternal(t, scope);
    }

    @Override
    public String toDebugHashCodeString() {
        boolean hasKnownTypeOfThis;
        if (this == this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE)) {
            return super.toDebugHashCodeString();
        }
        StringBuilder b = new StringBuilder(32);
        b.append("function (");
        int paramNum = this.call.parameters.getChildCount();
        boolean bl = hasKnownTypeOfThis = !this.typeOfThis.isUnknownType();
        if (hasKnownTypeOfThis) {
            b.append("this:");
            b.append(this.getDebugHashCodeStringOf(this.typeOfThis));
        }
        if (paramNum > 0) {
            if (hasKnownTypeOfThis) {
                b.append(", ");
            }
            Node p = this.call.parameters.getFirstChild();
            b.append(this.getDebugHashCodeStringOf(p.getJSType()));
            for (p = p.getNext(); p != null; p = p.getNext()) {
                b.append(", ");
                b.append(this.getDebugHashCodeStringOf(p.getJSType()));
            }
        }
        b.append(")");
        b.append(": ");
        b.append(this.getDebugHashCodeStringOf(this.call.returnType));
        return b.toString();
    }

    private String getDebugHashCodeStringOf(JSType type) {
        if (type == this) {
            return "me";
        }
        return type.toDebugHashCodeString();
    }

    private static enum Kind {
        ORDINARY,
        CONSTRUCTOR,
        INTERFACE;

    }
}

