/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.util.ReflectionUtil;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(template="system:/groovy/webui/core/UITree.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class})})
@Serialized
public class UITree
extends UIComponent {
    private String expandIcon = "expandIcon";
    private String colapseIcon = "collapseIcon";
    private String nullItemIcon = "uiIconEmpty";
    private String selectedIcon = "";
    private String icon = "";
    private String beanIdField_;
    private String beanChildCountField_;
    private String beanLabelField_;
    private String beanIconField_ = "";
    private Integer maxTitleCharacter_ = 0;
    private Collection<?> sibbling;
    private Collection<?> children;
    private Object selected;
    private Object parentSelected;
    private UIRightClickPopupMenu uiPopupMenu_;
    private boolean escapeHTML_ = false;

    public Object getFieldValue(Object bean, String field) throws Exception {
        Method method = ReflectionUtil.getGetBindingMethod((Object)bean, (String)field);
        return method.invoke(bean, ReflectionUtil.EMPTY_ARGS);
    }

    public void setBeanIdField(String beanIdField_) {
        this.beanIdField_ = beanIdField_;
    }

    public void setBeanIconField(String beanIconField_) {
        this.beanIconField_ = beanIconField_;
    }

    public void setBeanLabelField(String beanLabelField_) {
        this.beanLabelField_ = beanLabelField_;
    }

    public void setBeanChildCountField(String beanChildCountField) {
        this.beanChildCountField_ = beanChildCountField;
    }

    public Object getId(Object object) throws Exception {
        return this.getFieldValue(object, this.beanIdField_);
    }

    public String getActionLink() throws Exception {
        if (this.selected == null) {
            return "#";
        }
        if (this.parentSelected == null) {
            return this.event("ChangeNode");
        }
        return this.event("ChangeNode", (String)this.getId(this.parentSelected));
    }

    public boolean isSelected(Object obj) throws Exception {
        if (this.selected == null) {
            return false;
        }
        return this.getId(obj).equals(this.getId(this.selected));
    }

    public String getColapseIcon() {
        return this.colapseIcon;
    }

    public void setCollapseIcon(String colapseIcon) {
        this.colapseIcon = colapseIcon;
    }

    public String getExpandIcon() {
        return this.expandIcon;
    }

    public void setExpandIcon(String expandIcon) {
        this.expandIcon = expandIcon;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(String selectedIcon) {
        this.selectedIcon = selectedIcon;
    }

    public Collection<?> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<?> children) {
        this.children = children;
    }

    public <T> T getSelected() {
        return (T)this.selected;
    }

    public void setSelected(Object selectedObject) {
        this.selected = selectedObject;
    }

    public <T> T getParentSelected() {
        return (T)this.parentSelected;
    }

    public void setParentSelected(Object parentSelected) {
        this.parentSelected = parentSelected;
    }

    public Collection<?> getSibbling() {
        return this.sibbling;
    }

    public void setSibbling(Collection<?> sibbling) {
        this.sibbling = sibbling;
    }

    public UIRightClickPopupMenu getUIRightClickPopupMenu() {
        return this.uiPopupMenu_;
    }

    public void setUIRightClickPopupMenu(UIRightClickPopupMenu uiPopupMenu) {
        this.uiPopupMenu_ = uiPopupMenu;
        if (this.uiPopupMenu_ != null) {
            this.uiPopupMenu_.setParent(this);
        }
    }

    public void setEscapeHTML(boolean escape) {
        this.escapeHTML_ = escape;
    }

    public boolean getEscapeHTML() {
        return this.escapeHTML_;
    }

    public String event(String name, String beanId) throws Exception {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        if (uiForm != null) {
            return uiForm.event(name, this.getId(), beanId);
        }
        return super.event(name, beanId);
    }

    public String renderNode(Object obj) throws Exception {
        Object childCount;
        String nodeIcon = this.colapseIcon;
        String iconGroup = this.icon;
        String note = "";
        if (this.isSelected(obj)) {
            nodeIcon = this.expandIcon;
            iconGroup = this.selectedIcon;
            note = " nodeSelected";
        }
        if (this.getBeanChildCountField() != null && (childCount = this.getFieldValue(obj, this.getBeanChildCountField())) != null && childCount.getClass().isAssignableFrom(Integer.class) && (Integer)childCount == 0) {
            nodeIcon = this.nullItemIcon;
        }
        if ("DefaultPageIcon".equals(iconGroup)) {
            iconGroup = "uiIconFileMini uiIconLightGray";
        } else if ("GroupAdminIcon".equals(iconGroup) || "PortalIcon".equals(iconGroup)) {
            iconGroup = "uiIconGroup uiIconLightGray";
        }
        if (this.beanIconField_ != null && this.beanIconField_.length() > 0 && this.getFieldValue(obj, this.beanIconField_) != null) {
            iconGroup = (String)this.getFieldValue(obj, this.beanIconField_);
        }
        String objId = String.valueOf(this.getId(obj));
        String actionLink = this.event("ChangeNode", objId);
        String fieldValue = (String)this.getFieldValue(obj, this.beanLabelField_);
        StringBuilder builder = new StringBuilder();
        if (fieldValue.length() > this.getMaxTitleCharacter() && this.getMaxTitleCharacter() != 0) {
            fieldValue = fieldValue.substring(0, this.getMaxTitleCharacter() - 3) + "...";
        }
        if (this.escapeHTML_) {
            fieldValue = fieldValue != null ? HTMLEntityEncoder.getInstance().encode(fieldValue) : fieldValue;
        }
        CharSequence rightClick = "";
        if (this.uiPopupMenu_ != null) {
            rightClick = this.uiPopupMenu_.getJSOnclickShowPopup(objId, null);
        }
        if (nodeIcon.equals(this.expandIcon)) {
            builder.append(" <a href=\"javascript:void(0);\" class=\"uiIconNode ").append(nodeIcon).append(note).append("\" ").append(rightClick).append(" title=\"").append(fieldValue).append("\"").append(">");
        } else {
            builder.append(" <a href=\"javascript:void(0);\" class=\"uiIconNode ").append(nodeIcon).append(note).append("\" ").append(rightClick).append(" title=\"").append(fieldValue).append("\" onclick=\"").append(actionLink).append("\">");
        }
        builder.append("<i class=\"" + iconGroup + "\"></i>").append(fieldValue);
        builder.append(" </a>");
        return builder.toString();
    }

    public void renderUIComponent(UIComponent uicomponent) throws Exception {
        uicomponent.processRender((WebuiRequestContext)WebuiRequestContext.getCurrentInstance());
    }

    public <T extends UIComponent> T findComponentById(String id) {
        if (this.getId().equals(id)) {
            return (T)((Object)this);
        }
        if (this.uiPopupMenu_ == null) {
            return null;
        }
        return (T)this.uiPopupMenu_.findComponentById(id);
    }

    public <T extends UIComponent> T findFirstComponentOfType(Class<T> type) {
        if (type.isInstance((Object)this)) {
            return (T)((UIComponent)type.cast((Object)this));
        }
        if (this.uiPopupMenu_ == null) {
            return null;
        }
        return (T)this.uiPopupMenu_.findFirstComponentOfType(type);
    }

    public <T> void findComponentOfType(List<T> list, Class<T> type) {
        if (type.isInstance((Object)this)) {
            list.add(type.cast((Object)this));
        }
        if (this.uiPopupMenu_ == null) {
            return;
        }
        this.uiPopupMenu_.findComponentOfType(list, type);
    }

    public String getBeanIdField() {
        return this.beanIdField_;
    }

    public String getBeanChildCountField() {
        return this.beanChildCountField_;
    }

    public String getBeanLabelField() {
        return this.beanLabelField_;
    }

    public String getBeanIconField() {
        return this.beanIconField_;
    }

    public void setMaxTitleCharacter(Integer maxTitleCharacter_) {
        this.maxTitleCharacter_ = maxTitleCharacter_;
    }

    public Integer getMaxTitleCharacter() {
        return this.maxTitleCharacter_;
    }

    public UIRightClickPopupMenu getUiPopupMenu() {
        return this.uiPopupMenu_;
    }

    public void setUiPopupMenu(UIRightClickPopupMenu uiPopupMenu) {
        this.uiPopupMenu_ = uiPopupMenu;
    }

    public void setColapseIcon(String colapseIcon) {
        this.colapseIcon = colapseIcon;
    }

    public static class ChangeNodeActionListener
    extends EventListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            ((UITree)((Object)event.getSource())).getParent().broadcast(event, event.getExecutionPhase());
        }
    }
}

