/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.impl;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.exoplatform.services.organization.ExtendedCloneable;
import org.exoplatform.services.organization.User;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="EXO_USER")
public class UserImpl
implements User,
ExtendedCloneable,
Serializable {
    private static final long serialVersionUID = 6919266039776618161L;
    @Id
    private String id;
    @Column
    private String userName;
    @Column
    private String password;
    @Column
    private String firstName;
    @Column
    private String lastName;
    @Column
    private String email;
    @Column
    private Date createdDate;
    @Column
    private Date lastLoginTime;
    @Column
    private String organizationId;
    @Column
    private String displayName;
    @Column
    private Boolean enabled;

    public UserImpl() {
    }

    public UserImpl(String username) {
        this.userName = username;
    }

    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.getFirstName() + " " + this.getLastName();
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFullName() {
        return this.getDisplayName();
    }

    public void setFullName(String fullName) {
        this.setDisplayName(fullName);
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date t) {
        this.createdDate = t;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public void setLastLoginTime(Date t) {
        this.lastLoginTime = t;
    }

    public String toString() {
        return "User[" + this.id + "|" + this.userName + "]" + (this.organizationId == null ? "" : "@" + this.organizationId);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public boolean isEnabled() {
        return this.enabled == null || this.enabled != false;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public UserImpl clone() {
        UserImpl ui;
        try {
            ui = (UserImpl)super.clone();
            if (this.createdDate != null) {
                ui.createdDate = (Date)this.createdDate.clone();
            }
            if (this.lastLoginTime != null) {
                ui.lastLoginTime = (Date)this.lastLoginTime.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
        return ui;
    }
}

