/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.documents.AutoVersionService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.ext.utils.VersionHistoryUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class AutoVersionServiceImpl
implements AutoVersionService {
    private static Log log = ExoLogger.getLogger(AutoVersionServiceImpl.class);
    private ManageDriveService manageDriveService;
    private List<String> lstDriveAutoVersion = new ArrayList<String>();
    private int maxVersionNumber = 0;
    private int expiredTimeVersion = 0;

    public AutoVersionServiceImpl(ManageDriveService manageDriveService, InitParams params) {
        this.manageDriveService = manageDriveService;
        String driveAutoVersion = params.getValueParam("ecms.documents.versioning.drives").getValue();
        this.maxVersionNumber = Integer.parseInt(params.getValueParam("ecms.documents.versions.max").getValue());
        this.expiredTimeVersion = Integer.parseInt(params.getValueParam("ecms.documents.versions.expiration").getValue());
        if (StringUtils.isNotEmpty((String)driveAutoVersion)) {
            this.lstDriveAutoVersion = Arrays.asList(driveAutoVersion.split(","));
        }
    }

    @Override
    public void autoVersion(Node currentNode) throws Exception {
        this.autoVersion(currentNode, false);
    }

    @Override
    public void autoVersion(Node currentNode, boolean isSkipCheckDrive) throws Exception {
        this.manageDriveService = WCMCoreUtils.getService(ManageDriveService.class);
        if (currentNode.canAddMixin("mix:referenceable")) {
            currentNode.addMixin("mix:referenceable");
            currentNode.save();
        }
        if (isSkipCheckDrive) {
            VersionHistoryUtils.createVersion((Node)currentNode);
            return;
        }
        String nodePath = currentNode.getPath();
        for (String driveAutoVersion : this.lstDriveAutoVersion) {
            DriveData driveData = this.manageDriveService.getDriveByName(StringUtils.trim((String)driveAutoVersion));
            if (driveData == null) continue;
            String driveHomePath = driveData.getHomePath();
            if (!StringUtils.equals((String)driveData.getWorkspace(), (String)currentNode.getSession().getWorkspace().getName()) || !(driveHomePath.startsWith("/Users/${userId}/Private") && nodePath.startsWith("/Users") || driveHomePath.startsWith("/Groups${groupId}/Documents") && nodePath.startsWith("/Groups")) && !nodePath.startsWith(driveHomePath)) continue;
            VersionHistoryUtils.createVersion((Node)currentNode);
            return;
        }
    }

    @Override
    public boolean isVersionSupport(String nodePath, String workspace) throws Exception {
        if (StringUtils.isEmpty((String)nodePath)) {
            return false;
        }
        for (String driveAutoVersion : this.lstDriveAutoVersion) {
            DriveData driveData = this.manageDriveService.getDriveByName(StringUtils.trim((String)driveAutoVersion));
            if (driveData == null) continue;
            String driveHomePath = driveData.getHomePath();
            if (!StringUtils.equals((String)driveData.getWorkspace(), (String)workspace) || !(driveHomePath.startsWith("/Users/${userId}/Private") && nodePath.startsWith("/Users") || driveHomePath.startsWith("/Groups${groupId}/Documents") && nodePath.startsWith("/Groups")) && !nodePath.startsWith(driveHomePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getDriveAutoVersion() {
        return this.lstDriveAutoVersion;
    }

    @Override
    public void autoVersion(Node currentNode, Node sourceNode) throws Exception {
        this.autoVersion(currentNode, sourceNode, false);
    }

    @Override
    public void autoVersion(Node currentNode, Node sourceNode, boolean isSkipDriveCheck) throws Exception {
        this.manageDriveService = WCMCoreUtils.getService(ManageDriveService.class);
        if (currentNode.canAddMixin("mix:referenceable")) {
            currentNode.addMixin("mix:referenceable");
            currentNode.save();
        }
        if (isSkipDriveCheck) {
            this.createVersion(currentNode, sourceNode);
            return;
        }
        for (String driveAutoVersion : this.lstDriveAutoVersion) {
            DriveData driveData = this.manageDriveService.getDriveByName(StringUtils.trim((String)driveAutoVersion));
            if (driveData == null) continue;
            String driveHomePath = driveData.getHomePath();
            String nodePath = currentNode.getPath();
            if (!StringUtils.equals((String)driveData.getWorkspace(), (String)currentNode.getSession().getWorkspace().getName()) || !(driveHomePath.startsWith("/Users/${userId}/Private") && nodePath.startsWith("/Users") || driveHomePath.startsWith("/Groups${groupId}/Documents") && nodePath.startsWith("/Groups")) && !nodePath.startsWith(driveHomePath)) continue;
            this.createVersion(currentNode, sourceNode);
            return;
        }
    }

    private boolean createVersion(Node currentNode, Node sourceNode) throws Exception {
        if (currentNode.canAddMixin("mix:versionable")) {
            currentNode.addMixin("mix:versionable");
            currentNode.save();
            return true;
        }
        long allCurrentVersions = currentNode.getVersionHistory().getAllVersions().getSize();
        if (this.maxVersionNumber == 0 || (long)this.maxVersionNumber >= allCurrentVersions) {
            VersionHistoryUtils.createVersion((Node)currentNode);
            Node jcrContent = currentNode.hasNode("jcr:content") ? currentNode.getNode("jcr:content") : currentNode.addNode("jcr:content");
            Node srcJcrContent = sourceNode.getNode("jcr:content");
            if (srcJcrContent.getProperty("jcr:data").getStream().available() > 0) {
                jcrContent.setProperty("jcr:data", srcJcrContent.getProperty("jcr:data").getStream());
            }
            currentNode.save();
            return true;
        }
        return false;
    }
}

