/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.web.redirect.implementation;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gatein.web.redirect.api.RedirectHandler;
import org.gatein.web.redirect.api.SiteRedirectService;
import org.picocontainer.Startable;

public class RedirectHandlerImpl
implements RedirectHandler,
Startable {
    SiteRedirectService siteRedirectService;

    public RedirectHandlerImpl(SiteRedirectService siteRedirectService) {
        this.siteRedirectService = siteRedirectService;
    }

    @Override
    public Map<String, String> getAlternativeRedirects(String siteName, String URI, boolean setPreference) {
        Map<String, String> redirectNames = this.siteRedirectService.getAlternativeSites(siteName, true);
        LinkedHashMap<String, String> redirects = new LinkedHashMap<String, String>();
        for (String redirectName : redirectNames.keySet()) {
            String redirectURI = this.createRedirectURI(redirectNames.get(redirectName), URI);
            redirects.put(redirectName, redirectURI);
        }
        return redirects;
    }

    protected String createRedirectURI(String redirectSite, String URI) {
        String redirectURI = URI;
        if (redirectURI.contains("&")) {
            redirectURI = redirectURI + "?";
        } else {
            if (redirectURI.endsWith("/")) {
                redirectURI = redirectURI.substring(0, redirectURI.length() - 1);
            }
            redirectURI = redirectURI + "?";
        }
        redirectURI = redirectURI + "gtn_redirect=" + redirectSite;
        return redirectURI;
    }

    public void start() {
    }

    public void stop() {
    }
}

