/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.formula.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Vector;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.formula.AbstractFormulaRenderer;
import org.xwiki.formula.FormulaRenderer;
import org.xwiki.formula.ImageData;

@Component
@Named(value="native")
@Singleton
public class NativeFormulaRenderer
extends AbstractFormulaRenderer
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeFormulaRenderer.class);
    @Inject
    private Environment environment;
    private File tempDirectory;

    public void initialize() throws InitializationException {
        this.tempDirectory = new File(this.environment.getTemporaryDirectory(), "formulae");
        this.tempDirectory.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ImageData renderImage(String formula, boolean inline, FormulaRenderer.FontSize size, FormulaRenderer.Type type) throws IllegalArgumentException, IOException {
        ImageData imageData;
        File tmpDirectory = null;
        try {
            String texContent = "\\documentclass[10pt]{article}\n\\usepackage[paperheight=1000in]{geometry}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\usepackage{amssymb}\n\\usepackage{pst-plot}\n\\usepackage{color}\n\\pagestyle{empty}\n\\begin{document}\n" + size.getCommand() + "\n" + this.wrapFormula(formula, inline) + "\\end{document}\n";
            while ((tmpDirectory = new File(this.tempDirectory, RandomStringUtils.randomAlphanumeric((int)8))).exists()) {
            }
            tmpDirectory.mkdir();
            String baseName = tmpDirectory.getAbsolutePath() + "/file";
            String texFileName = baseName + ".tex";
            String dviFileName = baseName + ".dvi";
            String psFileName = baseName + ".ps";
            String imageFileName = baseName + type.getExtension();
            FileWriter fw = new FileWriter(texFileName);
            fw.write(texContent);
            fw.close();
            String[] commandLine = new String[]{"latex", "--interaction=nonstopmode", texFileName};
            this.executeCommand(commandLine, tmpDirectory);
            commandLine = new String[]{"dvips", "-E", dviFileName, "-o", psFileName};
            this.executeCommand(commandLine, tmpDirectory);
            commandLine = new String[]{"convert", "-density", "120", psFileName, imageFileName};
            this.executeCommand(commandLine, tmpDirectory);
            imageData = new ImageData(FileUtils.readFileToByteArray((File)new File(imageFileName)), type);
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(tmpDirectory);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)tmpDirectory);
        return imageData;
    }

    private boolean executeCommand(String[] commandLine, File cwd) throws IOException {
        Vector<String> commandList = new Vector<String>(commandLine.length);
        Collections.addAll(commandList, commandLine);
        ProcessBuilder processBuilder = new ProcessBuilder(commandList);
        processBuilder.directory(cwd);
        Process process = processBuilder.start();
        IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)new NullOutputStream());
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (process.exitValue() != 0) {
            LOGGER.debug("Error generating image: " + IOUtils.toString((InputStream)process.getErrorStream()));
        }
        return process.exitValue() == 0;
    }
}

