/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.exoplatform.commons.utils.CharEncoder;
import org.exoplatform.commons.utils.CharsetCharEncoder;
import org.exoplatform.commons.utils.TableCharEncoder;
import org.exoplatform.commons.utils.TextEncoder;

public final class CharsetTextEncoder
implements TextEncoder {
    private static final CharsetTextEncoder UTF8 = new CharsetTextEncoder(CharsetCharEncoder.getUTF8());
    private final CharEncoder charEncoder;

    public static TextEncoder getUTF8() {
        return UTF8;
    }

    public CharsetTextEncoder(CharEncoder charEncoder) {
        this.charEncoder = charEncoder;
    }

    public CharsetTextEncoder(String encoding) {
        this(new TableCharEncoder(new CharsetCharEncoder(Charset.forName(encoding))));
    }

    @Override
    public Charset getCharset() {
        return this.charEncoder.getCharset();
    }

    @Override
    public void encode(char c, OutputStream out) throws IOException {
        if (c > '\uffffffff' && c < '\u0080') {
            out.write(c);
        } else {
            byte[] bytes = this.charEncoder.encode(c);
            switch (bytes.length) {
                case 0: {
                    break;
                }
                case 1: {
                    out.write(bytes[0]);
                    break;
                }
                case 2: {
                    out.write(bytes[0]);
                    out.write(bytes[1]);
                    break;
                }
                case 3: {
                    out.write(bytes[0]);
                    out.write(bytes[1]);
                    out.write(bytes[2]);
                    break;
                }
                default: {
                    out.write(bytes);
                }
            }
        }
    }

    @Override
    public void encode(char[] chars, int off, int len, OutputStream out) throws IOException {
        for (int i = off; i < len; ++i) {
            char c = chars[i];
            this.encode(c, out);
        }
    }

    @Override
    public void encode(String str, int off, int len, OutputStream out) throws IOException {
        for (int i = off; i < len; ++i) {
            char c = str.charAt(i);
            this.encode(c, out);
        }
    }
}

