/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import uk.ac.ed.ph.snuggletex.internal.WorkingDocument;

public final class FrozenSlice {
    public final WorkingDocument document;
    public final int startIndex;
    public final int endIndex;
    private transient String stringRepresentation;

    public FrozenSlice(WorkingDocument document, int startIndex, int endIndex) {
        this.document = document;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public WorkingDocument getDocument() {
        return this.document;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public CharSequence extract() {
        return this.document.extract(this.startIndex, this.endIndex);
    }

    public boolean isWhitespace() {
        return this.document.isRegionWhitespace(this.startIndex, this.endIndex);
    }

    public FrozenSlice rightOuterSpan(FrozenSlice rightSlice) {
        this.ensureSharesDocumentWith(rightSlice);
        return this.document.freezeSlice(this.startIndex, rightSlice.endIndex);
    }

    public final boolean sharesDocumentWith(FrozenSlice otherSlice) {
        return this.document.equals(otherSlice.document);
    }

    protected final void ensureSharesDocumentWith(FrozenSlice otherSlice) {
        if (!this.sharesDocumentWith(otherSlice)) {
            throw new IllegalArgumentException("Document mismatch for FrozenSlice " + otherSlice);
        }
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append("(range=[").append(this.startIndex).append(",").append(this.endIndex).append("), value='").append(((Object)this.extract()).toString().replace("\n", "%n")).append("')");
            this.stringRepresentation = builder.toString();
        }
        return this.stringRepresentation;
    }
}

