/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.utilities;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public final class ClassPathURIResolver
implements URIResolver {
    public static final String URI_SCHEME = "classpath";
    private static final ClassPathURIResolver singletonInstance = new ClassPathURIResolver();

    private ClassPathURIResolver() {
    }

    public static ClassPathURIResolver getInstance() {
        return singletonInstance;
    }

    public Source resolve(String href, String base) throws TransformerException {
        URI baseUri;
        if (href.equals("")) {
            return null;
        }
        try {
            baseUri = new URI(base);
        }
        catch (URISyntaxException e) {
            throw new TransformerException("Could not convert base=" + base + " into a URI", e);
        }
        URI resolvedUri = baseUri.resolve(href);
        StreamSource result = null;
        if (URI_SCHEME.equals(resolvedUri.getScheme())) {
            String resourceLocation = resolvedUri.getPath().substring(1);
            InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(resourceLocation);
            if (resourceStream != null) {
                result = new StreamSource(resourceStream, resolvedUri.toString());
            } else {
                throw new TransformerException("Could not load resource at " + resourceLocation + " via ClassLoader");
            }
        }
        return result;
    }
}

