/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.WindowState;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.page.UIPageLifecycle;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.portal.webui.portal.UIPortalComposer;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIPageLifecycle.class, template="system:/groovy/portal/webui/page/UIPage.gtmpl", events={@EventConfig(listeners={UIPortalComponentActionListener.MoveChildActionListener.class}), @EventConfig(name="EditCurrentPage", listeners={EditCurrentPageActionListener.class})})
public class UIPage
extends UIContainer {
    private static final String FULL_PREVIEW_PROPERTY = "gatein.portal.pageEditor.fullPreview";
    private static Boolean fullPreview = null;
    private String pageId;
    private SiteKey siteKey;
    private String editPermission;
    private boolean showMaxWindow = false;
    private UIPortlet maximizedUIPortlet;
    public static String DEFAULT_FACTORY_ID = "Default";

    public static boolean isFullPreview() {
        if (fullPreview == null) {
            fullPreview = Boolean.valueOf(PropertyManager.getProperty((String)FULL_PREVIEW_PROPERTY));
        }
        return fullPreview;
    }

    public static boolean isFullPreviewInPageEditor() {
        if (!UIPage.isFullPreview()) {
            return false;
        }
        UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
        return uiPortalApp.getEditMode() == UIPortalApplication.EditMode.PREVIEW && uiPortalApp.getEditLevel() == UIPortalApplication.EditLevel.EDIT_PAGE;
    }

    public SiteKey getSiteKey() {
        return this.siteKey;
    }

    public void setSiteKey(SiteKey key) {
        this.siteKey = key;
    }

    @Deprecated
    public String getOwnerType() {
        return this.getSiteKey().getTypeName();
    }

    @Deprecated
    public String getOwnerId() {
        return this.getSiteKey().getName();
    }

    public boolean isShowMaxWindow() {
        return this.showMaxWindow;
    }

    public void setShowMaxWindow(Boolean showMaxWindow) {
        this.showMaxWindow = showMaxWindow;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String id) {
        this.pageId = id;
    }

    public UIPortlet getMaximizedUIPortlet() {
        return this.maximizedUIPortlet;
    }

    public void setMaximizedUIPortlet(UIPortlet maximizedUIPortlet) {
        this.maximizedUIPortlet = maximizedUIPortlet;
    }

    public void switchToEditMode() throws Exception {
        PageService pageService = (PageService)this.getApplicationComponent(PageService.class);
        DataStorage dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
        PageKey pageKey = new PageKey(this.getSiteKey(), this.getName());
        PageContext pageContext = pageService.loadPage(pageKey);
        if (pageContext == null) {
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            ApplicationMessage msg = new ApplicationMessage("UIPageBrowser.msg.PageNotExist", (Object[])new String[]{pageKey.format()}, 1);
            uiApp.addMessage(msg);
        } else {
            Page page = dataStorage.getPage(pageKey.format());
            pageContext.update(page);
            this.switchToEditMode(page);
        }
    }

    public void switchToEditMode(Page page) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        if (!userACL.hasEditPermission(page)) {
            context.getUIApplication().addMessage(new ApplicationMessage("UIPortalManagement.msg.Invalid-EditPage-Permission", null));
            return;
        }
        UIPortalApplication uiApp = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiApp.getChildById("UIWorkingWorkspace");
        uiWorkingWS.setRenderedChild(UIEditInlineWorkspace.class);
        UIPortalComposer portalComposer = (UIPortalComposer)((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(true);
        portalComposer.setComponentConfig(UIPortalComposer.class, "UIPageEditor");
        portalComposer.setId("UIPageEditor");
        portalComposer.setShowControl(true);
        portalComposer.setEditted(false);
        portalComposer.setCollapse(false);
        UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
        uiToolPanel.setShowMaskLayer(false);
        uiApp.setDefaultEditMode(UIPortalApplication.ComponentTab.APPLICATIONS, UIPortalApplication.EditLevel.EDIT_PAGE);
        UIPage newUIPage = (UIPage)uiWorkingWS.createUIComponent(UIPage.class, null, null);
        PortalDataMapper.toUIPage(newUIPage, page);
        uiToolPanel.setWorkingComponent((UIComponent)newUIPage);
        UIPageBody pageBody = (UIPageBody)uiWorkingWS.findFirstComponentOfType(UIPageBody.class);
        pageBody.setUIComponent(null);
        PortalRequestContext prContext = Util.getPortalRequestContext();
        prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        prContext.setFullRender(true);
    }

    private List<UIPortlet> recursivelyFindUIPortlets(org.exoplatform.webui.core.UIContainer uiContainer) {
        ArrayList<UIPortlet> uiPortletList = new ArrayList<UIPortlet>();
        for (UIComponent uiComponent : uiContainer.getChildren()) {
            if (!org.exoplatform.webui.core.UIContainer.class.isAssignableFrom(uiComponent.getClass())) continue;
            org.exoplatform.webui.core.UIContainer childUIContainer = (org.exoplatform.webui.core.UIContainer)uiComponent;
            if (UIPortlet.class.isAssignableFrom(childUIContainer.getClass())) {
                uiPortletList.add((UIPortlet)childUIContainer);
                continue;
            }
            uiPortletList.addAll(this.recursivelyFindUIPortlets(childUIContainer));
        }
        return uiPortletList;
    }

    public void normalizePortletWindowStates() {
        for (UIPortlet childUIPortlet : this.recursivelyFindUIPortlets(this)) {
            if (WindowState.MINIMIZED.equals((Object)childUIPortlet.getCurrentWindowState())) continue;
            childUIPortlet.setCurrentWindowState(WindowState.NORMAL);
        }
    }

    @Override
    public String getPermissionClasses() {
        StringBuilder permissionClasses = new StringBuilder();
        if (!this.hasMoveAppsPermission()) {
            permissionClasses.append(" CannotMoveApps");
        }
        if (!this.hasMoveContainersPermission()) {
            permissionClasses.append(" CannotMoveContainers");
        }
        return permissionClasses.toString();
    }

    public static class EditCurrentPageActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            ((UIPage)((Object)event.getSource())).switchToEditMode();
        }
    }
}

