/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import java.io.File;
import java.io.IOException;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.common.util.TimeSource;
import org.exoplatform.portal.gadget.core.ExoContainerConfig;
import org.exoplatform.portal.gadget.core.SecurityTokenGenerator;
import org.exoplatform.web.application.RequestContext;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ExoDefaultSecurityTokenGenerator
implements SecurityTokenGenerator {
    private final TimeSource timeSource;
    private final Logger log = LoggerFactory.getLogger(ExoDefaultSecurityTokenGenerator.class);

    public ExoDefaultSecurityTokenGenerator() throws Exception {
        this.timeSource = new TimeSource();
    }

    protected String createToken(String gadgetURL, String owner, String viewer, Long moduleId, String container) {
        try {
            BlobCrypter blobCrypter = this.getBlobCrypter();
            BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(blobCrypter, container, null);
            t.setAppUrl(gadgetURL);
            t.setModuleId(moduleId.longValue());
            t.setOwnerId(owner);
            t.setViewerId(viewer);
            t.setTrustedJson("trusted");
            return t.encrypt();
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BlobCrypterException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public String createToken(String gadgetURL, Long moduleId) {
        String rUser;
        RequestContext context = RequestContext.getCurrentInstance();
        String viewer = rUser = context.getRemoteUser();
        return this.createToken(gadgetURL, viewer, rUser, moduleId, "default");
    }

    protected BlobCrypter getBlobCrypter() throws IOException {
        String fileName = this.getKeyFilePath();
        BasicBlobCrypter c = new BasicBlobCrypter(new File(fileName));
        c.timeSource = this.timeSource;
        return c;
    }

    protected String getKeyFilePath() {
        String keyPath = ExoContainerConfig.getTokenKeyPath();
        File keyFile = null;
        keyFile = keyPath != null ? new File(keyPath) : new File("key.txt");
        return keyFile.getAbsolutePath();
    }
}

