/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import org.hsqldb.Database;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.LineReader;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.Crypto;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderText;

public class ScriptReaderDecode
extends ScriptReaderText {
    DataInputStream dataInput;
    InputStream cryptoStream;
    Crypto crypto;
    byte[] buffer = new byte[256];

    public ScriptReaderDecode(Database database, String string, Crypto crypto, boolean bl) throws IOException {
        super(database);
        this.crypto = crypto;
        try {
            this.inputStream = database.logger.getFileAccess().openInputStreamElement(string);
            this.bufferedStream = new BufferedInputStream(this.inputStream);
            this.rowIn = new RowInputTextLog();
            if (bl) {
                this.dataInput = new DataInputStream(this.bufferedStream);
            } else {
                this.cryptoStream = crypto.getInputStream(this.bufferedStream);
                this.gzipStream = new GZIPInputStream(this.cryptoStream);
                this.dataStreamIn = new LineReader(this.gzipStream, "ISO-8859-1");
            }
        }
        catch (Throwable throwable) {
            this.close();
            throw JavaSystem.toIOException(throwable);
        }
    }

    @Override
    public boolean readLoggedStatement(Session session) {
        String string;
        int n;
        if (this.dataInput == null) {
            return super.readLoggedStatement(session);
        }
        try {
            n = this.dataInput.readInt();
            if (n * 2 > this.buffer.length) {
                this.buffer = new byte[n * 2];
            }
            this.dataInput.readFully(this.buffer, 0, n);
        }
        catch (Throwable throwable) {
            return false;
        }
        n = this.crypto.decode(this.buffer, 0, n, this.buffer, 0);
        try {
            string = new String(this.buffer, 0, n, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Error.error(unsupportedEncodingException, 452, null);
        }
        ++this.lineCount;
        this.statement = StringConverter.unicodeStringToString(string);
        if (this.statement == null) {
            return false;
        }
        this.processStatement(session);
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.dataStreamIn != null) {
                this.dataStreamIn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.gzipStream != null) {
                this.gzipStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.cryptoStream != null) {
                this.cryptoStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dataInput != null) {
                this.dataInput.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

