/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.service.plugin;

import java.util.List;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.common.service.MenuConfiguratorService;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MenuConfiguratorRemoveNodePlugin
extends BaseComponentPlugin {
    private MenuConfiguratorService menuConfiguratorService;
    private PageNode targetNode;
    private static final String TARGET_NODE = "node.config";
    private static final Log LOG = ExoLogger.getLogger(MenuConfiguratorRemoveNodePlugin.class);

    public MenuConfiguratorRemoveNodePlugin(MenuConfiguratorService menuConfiguratorService, InitParams initParams) {
        this.menuConfiguratorService = menuConfiguratorService;
        if (initParams.containsKey((Object)TARGET_NODE)) {
            this.targetNode = (PageNode)initParams.getObjectParam(TARGET_NODE).getObject();
        }
    }

    public void execute() {
        if (this.targetNode != null) {
            List<PageNode> setupPageNodes = this.menuConfiguratorService.getSetupMenuOriginalPageNodes();
            if (this.targetNode.getName() != null && this.targetNode.getPageReference() != null && !this.targetNode.getName().isEmpty() && !this.targetNode.getPageReference().isEmpty()) {
                boolean isRemoved = this.removeTargetNode(this.targetNode, setupPageNodes);
                if (!isRemoved) {
                    LOG.warn((Object)"Node specified in node.config param not found. Please check the configuration");
                }
            } else {
                LOG.warn((Object)"Node not removed : Both name and pageReference should be specified for the target node");
            }
        } else {
            LOG.warn((Object)"No node removed : target node should be specified");
        }
    }

    private boolean removeTargetNode(PageNode targetNode, List<PageNode> setupPageNodes) {
        boolean isFound = false;
        for (PageNode pageNode : setupPageNodes) {
            if (pageNode.getName().equals(targetNode.getName()) && pageNode.getPageReference().equals(targetNode.getPageReference())) {
                int i = setupPageNodes.indexOf(pageNode);
                setupPageNodes.remove(i);
                isFound = true;
                break;
            }
            List L = pageNode.getChildren();
            if (L == null || !(isFound = this.removeTargetNode(targetNode, L))) continue;
            break;
        }
        return isFound;
    }
}

