/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ResourceBundle;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

public class UISpaceSettings
extends UIFormInputSet {
    public static final String SPACE_DISPLAY_NAME = "displayName";
    public static final String SPACE_DESCRIPTION = "description";
    private final String MSG_INVALID_SPACE_NAME = "UISpaceSettings.msg.invalid_space_name";
    private static final String HTML_ATTRIBUTE_PLACEHOLDER = "placeholder";

    public UISpaceSettings(String name) throws Exception {
        super(name);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SPACE_DISPLAY_NAME, SPACE_DISPLAY_NAME, "").addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^[\\p{L}\\d\\s']+$", "UISpaceSettings.msg.invalid_space_name"}).addValidator(StringLengthValidator.class, new Object[]{3, 30}));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(SPACE_DESCRIPTION, SPACE_DESCRIPTION, ""));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        ResourceBundle resourceBundle = context.getApplicationResourceBundle();
        this.getUIStringInput(SPACE_DISPLAY_NAME).setHTMLAttribute(HTML_ATTRIBUTE_PLACEHOLDER, resourceBundle.getString("UISpaceSettings.label.spaceDisplayName"));
        String scripts = "(function(jq){jq(\"textarea#" + SPACE_DESCRIPTION + "\").attr(\"placeholder\", \"" + resourceBundle.getString("UISpaceSettings.label.spaceDescription") + "\");})(jq);";
        context.getJavascriptManager().getRequireJS().require("SHARED/jquery", "jq").addScripts(scripts);
        super.processRender(context);
    }
}

