/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.comment;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.rest.api.CommentRestResources;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.CommentEntity;

@Path(value="v1/social/comments")
@Api(tags={"v1/social/comments"}, value="v1/social/comments", description="Operations on a comment")
public class CommentRestResourcesV1
implements CommentRestResources {
    @Override
    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific comment by id", httpMethod="GET", response=Response.class, notes="This returns the comment if the authenticated user has permissions to see the related activity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getCommentById(@Context UriInfo uriInfo, @ApiParam(value="Comment id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        ExoSocialActivity act = activityManager.getActivity(id);
        if (act == null || !act.isComment()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        CommentEntity commentEntity = EntityBuilder.buildEntityFromComment(act, uriInfo.getPath(), expand, false);
        return EntityBuilder.getResponse(commentEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates a specific comment by id", httpMethod="PUT", response=Response.class, notes="This updates the comment in the following cases: <br/><ul><li>the authenticated user is the owner of the comment</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response updateCommentById(@Context UriInfo uriInfo, @ApiParam(value="Comment id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a subresource if any", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Comment object to be updated, in which the title of comment is required.", required=true) ActivityEntity model) throws Exception {
        if (model == null || model.getTitle() == null || model.getTitle().length() == 0) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        ExoSocialActivity act = activityManager.getActivity(id);
        if (act == null || !act.getPosterId().equals(currentUser.getId())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (!act.isComment()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        act.setTitle(model.getTitle());
        activityManager.updateActivity(act);
        ActivityEntity activityInfo = EntityBuilder.buildEntityFromActivity(act, uriInfo.getPath(), expand);
        return EntityBuilder.getResponse(activityInfo.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a specific comment by id", httpMethod="DELETE", response=Response.class, notes="This deletes the comment in the following cases: <br/><ul><li>the authenticated user is the owner of the comment</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response deleteCommentById(@Context UriInfo uriInfo, @ApiParam(value="Comment id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        ExoSocialActivity act = activityManager.getActivity(id);
        if (act == null || !act.isComment() || !act.getPosterId().equals(currentUser.getId())) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity(act, uriInfo.getPath(), expand);
        activityManager.deleteActivity(act);
        return EntityBuilder.getResponse(activityEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }
}

