/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;

public class UpgradeProductInfoNodePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)UpgradeProductInfoNodePlugin.class.getName());
    private static final String EXO_APPLICATIONS_DATA_NODE_ALIAS = "exoApplicationDataNode";
    private static final String UPGRADE_PRODUCT_SERVICE_NODE_NAME = "ProductInformationsService";
    private static final String PRODUCT_VERSION_DECLARATION_NODE_NAME = "productVersionDeclarationNode";
    private RepositoryService repoService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private UserACL userAcl;

    public UpgradeProductInfoNodePlugin(InitParams initParams, RepositoryService repoService, NodeHierarchyCreator nodeHierarchyCreator, UserACL userAcl) {
        super(initParams);
        this.repoService = repoService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.userAcl = userAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"processing upgrading product info node...");
        try (SessionProvider sessionProvider = null;){
            String applicationDataRootNodePath = this.nodeHierarchyCreator.getJcrPath(EXO_APPLICATIONS_DATA_NODE_ALIAS);
            sessionProvider = SessionProvider.createSystemProvider();
            String workspace = this.repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            Session session = sessionProvider.getSession(workspace, this.repoService.getCurrentRepository());
            Node applicationDataNode = (Node)session.getItem(applicationDataRootNodePath);
            Node productVersionDeclarationNode = applicationDataNode.getNode("ProductInformationsService/productVersionDeclarationNode");
            ExtendedNode extendedNode = (ExtendedNode)productVersionDeclarationNode;
            if (!extendedNode.isCheckedOut()) {
                extendedNode.checkout();
            }
            if (extendedNode.canAddMixin("exo:privilegeable")) {
                extendedNode.addMixin("exo:privilegeable");
            }
            HashMap<String, String[]> perms = new HashMap<String, String[]>();
            perms.put(IdentityConstants.SYSTEM, PermissionType.ALL);
            perms.put("*:" + this.userAcl.getAdminGroups(), PermissionType.ALL);
            extendedNode.setPermissions(perms);
            extendedNode.save();
            LOG.info((Object)"Product info node upgraded successfully!");
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

