/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.api;

import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.RelationshipStorageException;

public interface RelationshipStorage {
    public Relationship saveRelationship(Relationship var1) throws RelationshipStorageException;

    public void removeRelationship(Relationship var1) throws RelationshipStorageException;

    public Relationship getRelationship(String var1) throws RelationshipStorageException;

    public List<Relationship> getSenderRelationships(Identity var1, Relationship.Type var2, List<Identity> var3) throws RelationshipStorageException;

    public List<Relationship> getSenderRelationships(String var1, Relationship.Type var2, List<Identity> var3) throws RelationshipStorageException;

    public List<Relationship> getReceiverRelationships(Identity var1, Relationship.Type var2, List<Identity> var3) throws RelationshipStorageException;

    public Relationship getRelationship(Identity var1, Identity var2) throws RelationshipStorageException;

    public boolean hasRelationship(Identity var1, Identity var2, String var3) throws RepositoryException;

    public List<Relationship> getRelationships(Identity var1, Relationship.Type var2, List<Identity> var3) throws RelationshipStorageException;

    public List<Identity> getRelationships(Identity var1, long var2, long var4) throws RelationshipStorageException;

    public List<Identity> getIncomingRelationships(Identity var1, long var2, long var4) throws RelationshipStorageException;

    public int getIncomingRelationshipsCount(Identity var1) throws RelationshipStorageException;

    public List<Identity> getOutgoingRelationships(Identity var1, long var2, long var4) throws RelationshipStorageException;

    public int getOutgoingRelationshipsCount(Identity var1) throws RelationshipStorageException;

    public int getRelationshipsCount(Identity var1) throws RelationshipStorageException;

    public List<Identity> getConnections(Identity var1, long var2, long var4) throws RelationshipStorageException;

    public List<Identity> getConnections(Identity var1) throws RelationshipStorageException;

    public int getConnectionsCount(Identity var1) throws RelationshipStorageException;

    public List<Identity> getConnectionsByFilter(Identity var1, ProfileFilter var2, long var3, long var5) throws RelationshipStorageException;

    public List<Identity> getIncomingByFilter(Identity var1, ProfileFilter var2, long var3, long var5) throws RelationshipStorageException;

    public List<Identity> getOutgoingByFilter(Identity var1, ProfileFilter var2, long var3, long var5) throws RelationshipStorageException;

    public int getConnectionsCountByFilter(Identity var1, ProfileFilter var2) throws RelationshipStorageException;

    public int getIncomingCountByFilter(Identity var1, ProfileFilter var2) throws RelationshipStorageException;

    public int getOutgoingCountByFilter(Identity var1, ProfileFilter var2) throws RelationshipStorageException;

    public Map<Identity, Integer> getSuggestions(Identity var1, int var2, int var3, int var4) throws RelationshipStorageException;

    public List<Identity> getLastConnections(Identity var1, int var2) throws RelationshipStorageException;

    public List<Relationship> getRelationshipsByStatus(Identity var1, Relationship.Type var2, long var3, long var5);

    public int getRelationshipsCountByStatus(Identity var1, Relationship.Type var2);
}

