/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms.scripts;

import java.util.ArrayList;
import java.util.Collection;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanException;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.DBCleaningScripts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSQLDBCleaningScipts
extends DBCleaningScripts {
    public HSQLDBCleaningScipts(String dialect, RepositoryEntry rEntry) throws DBCleanException {
        super(dialect, rEntry);
        this.prepareRenamingApproachScripts();
    }

    public HSQLDBCleaningScipts(String dialect, WorkspaceEntry wEntry) throws DBCleanException {
        super(dialect, wEntry);
        if (this.multiDb) {
            this.prepareRenamingApproachScripts();
        } else {
            this.prepareSimpleCleaningApproachScripts();
        }
    }

    @Override
    protected Collection<String> getTablesRenamingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("ALTER TABLE " + this.valueTableName + " RENAME TO " + this.valueTableName + "_OLD");
        scripts.add("ALTER TABLE " + this.itemTableName + " RENAME TO " + this.itemTableName + "_OLD");
        scripts.add("ALTER TABLE " + this.refTableName + " RENAME TO " + this.refTableName + "_OLD");
        scripts.add("ALTER TABLE " + this.valueTableName + "_OLD DROP CONSTRAINT JCR_FK_" + this.valueTableSuffix + "_PROPERTY");
        scripts.add("ALTER TABLE " + this.itemTableName + "_OLD DROP CONSTRAINT JCR_FK_" + this.itemTableSuffix + "_PARENT");
        scripts.add("ALTER TABLE " + this.itemTableName + "_OLD DROP CONSTRAINT JCR_PK_" + this.itemTableSuffix);
        scripts.add("ALTER TABLE " + this.valueTableName + "_OLD DROP CONSTRAINT JCR_PK_" + this.valueTableSuffix);
        scripts.add("ALTER TABLE " + this.refTableName + "_OLD DROP CONSTRAINT JCR_PK_" + this.refTableSuffix);
        scripts.add("ALTER INDEX  JCR_IDX_" + this.itemTableSuffix + "_PARENT RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT_OLD");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME_OLD");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID_OLD");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM RENAME TO JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM_OLD");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.itemTableSuffix + "_NAME RENAME TO JCR_IDX_" + this.itemTableSuffix + "_NAME_OLD");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.valueTableSuffix + "_PROPERTY RENAME TO JCR_IDX_" + this.valueTableSuffix + "_PROPERTY_OLD");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.refTableSuffix + "_PROPERTY RENAME TO JCR_IDX_" + this.refTableSuffix + "_PROPERTY_OLD");
        return scripts;
    }

    @Override
    protected Collection<String> getOldTablesRenamingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("ALTER TABLE " + this.valueTableName + "_OLD RENAME TO " + this.valueTableName);
        scripts.add("ALTER TABLE " + this.itemTableName + "_OLD RENAME TO " + this.itemTableName);
        scripts.add("ALTER TABLE " + this.refTableName + "_OLD RENAME TO " + this.refTableName);
        scripts.add("ALTER TABLE " + this.itemTableName + " ADD CONSTRAINT JCR_PK_" + this.itemTableSuffix + " PRIMARY KEY(ID)");
        scripts.add("ALTER TABLE  " + this.valueTableName + " ADD CONSTRAINT JCR_FK_" + this.valueTableSuffix + "_PROPERTY FOREIGN KEY(PROPERTY_ID) REFERENCES " + this.itemTableName + "(ID)");
        scripts.add("ALTER TABLE " + this.itemTableName + " ADD CONSTRAINT JCR_FK_" + this.itemTableSuffix + "_PARENT FOREIGN KEY(PARENT_ID) REFERENCES " + this.itemTableName + "(ID)");
        scripts.add("ALTER TABLE  " + this.valueTableName + " ADD CONSTRAINT JCR_PK_" + this.valueTableSuffix + " PRIMARY KEY(ID)");
        scripts.add("ALTER TABLE  " + this.refTableName + " ADD CONSTRAINT JCR_PK_" + this.refTableSuffix + " PRIMARY KEY(NODE_ID, PROPERTY_ID, ORDER_NUM)");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.itemTableSuffix + "_PARENT_OLD RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME_OLD RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID_OLD RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM_OLD RENAME TO JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.itemTableSuffix + "_NAME_OLD RENAME TO JCR_IDX_" + this.itemTableSuffix + "_NAME");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.valueTableSuffix + "_PROPERTY_OLD RENAME TO JCR_IDX_" + this.valueTableSuffix + "_PROPERTY");
        scripts.add("ALTER INDEX  JCR_IDX_" + this.refTableSuffix + "_PROPERTY_OLD RENAME TO JCR_IDX_" + this.refTableSuffix + "_PROPERTY");
        return scripts;
    }
}

