/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractNamespaceMappings;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileBasedNamespaceMappings
extends AbstractNamespaceMappings {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.NamespaceMappings");
    private final File storage;
    private Map<String, String> prefixToURI = new HashMap<String, String>();
    private Map<String, String> uriToPrefix = new HashMap<String, String>();
    private int prefixCount;

    public FileBasedNamespaceMappings(File file) throws IOException {
        this.storage = file;
        this.load();
    }

    public synchronized String getNamespaceURIByPrefix(String prefix) throws NamespaceException {
        if (!this.prefixToURI.containsKey(prefix)) {
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }
        return this.prefixToURI.get(prefix);
    }

    public synchronized String getNamespacePrefixByURI(String uri) throws NamespaceException {
        String prefix = this.uriToPrefix.get(uri);
        if (prefix == null) {
            while (this.prefixToURI.get(String.valueOf(this.prefixCount)) != null) {
                ++this.prefixCount;
            }
            prefix = String.valueOf(this.prefixCount);
            this.prefixToURI.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
            log.debug((Object)("adding new namespace mapping: " + prefix + " -> " + uri));
            try {
                this.store();
            }
            catch (IOException e) {
                throw new NamespaceException("Could not obtain a prefix for uri: " + uri, (Throwable)e);
            }
        }
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        if (PrivilegedFileHelper.exists((File)this.storage)) {
            FileInputStream in = PrivilegedFileHelper.fileInputStream((File)this.storage);
            try {
                Properties props = new Properties();
                log.debug((Object)"loading namespace mappings...");
                props.load(in);
                for (String string : props.keySet()) {
                    String uri = props.getProperty(string);
                    log.debug((Object)(string + " -> " + uri));
                    this.prefixToURI.put(string, uri);
                    this.uriToPrefix.put(uri, string);
                }
                this.prefixCount = props.size();
                log.debug((Object)"namespace mappings loaded.");
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        Properties props = new Properties();
        for (String prefix : this.prefixToURI.keySet()) {
            String uri = this.prefixToURI.get(prefix);
            props.setProperty(prefix, uri);
        }
        OutputStream out = PrivilegedFileHelper.fileOutputStream((File)this.storage);
        try {
            out = new BufferedOutputStream(out);
            props.store(out, null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public String[] getAllNamespacePrefixes() throws RepositoryException {
        return this.prefixToURI.keySet().toArray(new String[this.prefixToURI.keySet().size()]);
    }
}

