/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota.infinispan;

import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.MappedParametrizedObjectEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.quota.AbstractQuotaPersister;
import org.exoplatform.services.jcr.impl.quota.UnknownDataSizeException;
import org.exoplatform.services.jcr.impl.quota.UnknownQuotaLimitException;
import org.exoplatform.services.jcr.impl.quota.infinispan.GlobalDataSizeKey;
import org.exoplatform.services.jcr.impl.quota.infinispan.GlobalQuotaKey;
import org.exoplatform.services.jcr.impl.quota.infinispan.GroupOfNodesQuotaKey;
import org.exoplatform.services.jcr.impl.quota.infinispan.NodeDataSizeKey;
import org.exoplatform.services.jcr.impl.quota.infinispan.NodeQuotaKey;
import org.exoplatform.services.jcr.impl.quota.infinispan.PathBasedKey;
import org.exoplatform.services.jcr.impl.quota.infinispan.QuotaValue;
import org.exoplatform.services.jcr.impl.quota.infinispan.RepositoryDataSizeKey;
import org.exoplatform.services.jcr.impl.quota.infinispan.RepositoryQuotaKey;
import org.exoplatform.services.jcr.impl.quota.infinispan.WorkspaceBasedKey;
import org.exoplatform.services.jcr.impl.quota.infinispan.WorkspaceDataSizeKey;
import org.exoplatform.services.jcr.impl.quota.infinispan.WorkspaceQuotaKey;
import org.exoplatform.services.jcr.infinispan.CacheKey;
import org.exoplatform.services.jcr.infinispan.ISPNCacheFactory;
import org.exoplatform.services.jcr.infinispan.PrivilegedISPNCacheHelper;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISPNQuotaPersister
extends AbstractQuotaPersister {
    private AdvancedCache<Serializable, Object> cache;

    protected ISPNQuotaPersister(MappedParametrizedObjectEntry entry, ConfigurationManager cfm) throws RepositoryConfigurationException {
        ISPNCacheFactory factory = new ISPNCacheFactory(cfm);
        this.cache = factory.createCache("quota", entry).getAdvancedCache();
        this.cache.start();
    }

    @Override
    public void destroy() {
        PrivilegedISPNCacheHelper.stop(this.cache);
        ISPNCacheFactory.releaseUniqueInstance(this.cache.getCacheManager());
    }

    @Override
    public void setNodeQuota(String repositoryName, String workspaceName, String nodePath, long quotaLimit, boolean asyncUpdate) {
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        NodeQuotaKey key = new NodeQuotaKey(workspaceUniqueName, nodePath);
        QuotaValue value = new QuotaValue(quotaLimit, asyncUpdate);
        this.cache.put((Object)key, (Object)value);
    }

    @Override
    public void setGroupOfNodesQuota(String repositoryName, String workspaceName, String patternPath, long quotaLimit, boolean asyncUpdate) {
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        GroupOfNodesQuotaKey key = new GroupOfNodesQuotaKey(workspaceUniqueName, patternPath);
        QuotaValue value = new QuotaValue(quotaLimit, asyncUpdate);
        this.cache.put((Object)key, (Object)value);
    }

    @Override
    public long getNodeDataSize(String repositoryName, String workspaceName, String nodePath) throws UnknownDataSizeException {
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        NodeDataSizeKey key = new NodeDataSizeKey(workspaceUniqueName, nodePath);
        return this.getDataSize(key);
    }

    @Override
    public void setNodeDataSize(String repositoryName, String workspaceName, String nodePath, long dataSize) {
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        NodeDataSizeKey key = new NodeDataSizeKey(workspaceUniqueName, nodePath);
        this.cache.put((Object)key, (Object)dataSize);
    }

    @Override
    public void removeNodeDataSize(String repositoryName, String workspaceName, String nodePath) {
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        NodeDataSizeKey key = new NodeDataSizeKey(workspaceUniqueName, nodePath);
        this.cache.remove((Object)key);
    }

    @Override
    public long getWorkspaceQuota(String repositoryName, String workspaceName) throws UnknownQuotaLimitException {
        String wsUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        WorkspaceQuotaKey key = new WorkspaceQuotaKey(wsUniqueName);
        return this.getQuota(key);
    }

    @Override
    public void setWorkspaceQuota(final String repositoryName, final String workspaceName, final long quotaLimit) {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String wsUniqueName = ISPNQuotaPersister.this.composeWorkspaceUniqueName(repositoryName, workspaceName);
                WorkspaceQuotaKey key = new WorkspaceQuotaKey(wsUniqueName);
                ISPNQuotaPersister.this.cache.put((Object)key, (Object)quotaLimit);
                return null;
            }
        });
    }

    @Override
    public void removeWorkspaceQuota(String repositoryName, String workspaceName) {
        String wsUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        WorkspaceQuotaKey key = new WorkspaceQuotaKey(wsUniqueName);
        this.cache.remove((Object)key);
    }

    @Override
    public void setWorkspaceDataSize(final String repositoryName, final String workspaceName, final long dataSize) {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String wsUniqueName = ISPNQuotaPersister.this.composeWorkspaceUniqueName(repositoryName, workspaceName);
                WorkspaceDataSizeKey key = new WorkspaceDataSizeKey(wsUniqueName);
                ISPNQuotaPersister.this.cache.put((Object)key, (Object)dataSize);
                return null;
            }
        });
    }

    @Override
    public long getWorkspaceDataSize(String repositoryName, String workspaceName) throws UnknownDataSizeException {
        String wsUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        WorkspaceDataSizeKey key = new WorkspaceDataSizeKey(wsUniqueName);
        return this.getDataSize(key);
    }

    @Override
    public long getRepositoryQuota(String repositoryName) throws UnknownQuotaLimitException {
        RepositoryQuotaKey key = new RepositoryQuotaKey(repositoryName);
        return this.getQuota(key);
    }

    @Override
    public void setRepositoryQuota(final String repositoryName, final long quotaLimit) {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                RepositoryQuotaKey key = new RepositoryQuotaKey(repositoryName);
                ISPNQuotaPersister.this.cache.put((Object)key, (Object)quotaLimit);
                return null;
            }
        });
    }

    @Override
    public void removeRepositoryQuota(String repositoryName) {
        RepositoryQuotaKey key = new RepositoryQuotaKey(repositoryName);
        this.cache.remove((Object)key);
    }

    @Override
    public long getRepositoryDataSize(String repositoryName) throws UnknownDataSizeException {
        RepositoryDataSizeKey key = new RepositoryDataSizeKey(repositoryName);
        return this.getDataSize(key);
    }

    @Override
    public void setRepositoryDataSize(String repositoryName, long dataSize) {
        RepositoryDataSizeKey key = new RepositoryDataSizeKey(repositoryName);
        this.cache.put((Object)key, (Object)dataSize);
    }

    @Override
    public long getGlobalDataSize() throws UnknownDataSizeException {
        GlobalDataSizeKey key = new GlobalDataSizeKey();
        return this.getDataSize(key);
    }

    @Override
    public void setGlobalDataSize(final long dataSize) {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                GlobalDataSizeKey key = new GlobalDataSizeKey();
                ISPNQuotaPersister.this.cache.put((Object)key, (Object)dataSize);
                return null;
            }
        });
    }

    @Override
    public long getGlobalQuota() throws UnknownQuotaLimitException {
        GlobalQuotaKey key = new GlobalQuotaKey();
        return this.getQuota(key);
    }

    @Override
    public void setGlobalQuota(long quotaLimit) {
        GlobalQuotaKey key = new GlobalQuotaKey();
        this.cache.put((Object)key, (Object)quotaLimit);
    }

    @Override
    public void removeGlobalQuota() {
        GlobalQuotaKey key = new GlobalQuotaKey();
        this.cache.remove((Object)key);
    }

    @Override
    public void clearWorkspaceData(String repositoryName, String workspaceName) throws BackupException {
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        for (Serializable cacheKey : this.cache.keySet()) {
            if (!(cacheKey instanceof WorkspaceBasedKey) || !workspaceUniqueName.equals(((WorkspaceBasedKey)cacheKey).getWorkspaceUniqueName())) continue;
            this.cache.remove((Object)cacheKey);
        }
    }

    @Override
    public long getNodeQuota(String repositoryName, String workspaceName, String nodePath) throws UnknownQuotaLimitException {
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        NodeQuotaKey key = new NodeQuotaKey(workspaceUniqueName, nodePath);
        return this.getQuotaValue(key).getQuotaLimit();
    }

    @Override
    public long getGroupOfNodesQuota(String repositoryName, String workspaceName, String patternPath) throws UnknownQuotaLimitException {
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        GroupOfNodesQuotaKey key = new GroupOfNodesQuotaKey(workspaceUniqueName, patternPath);
        return this.getQuotaValue(key).getQuotaLimit();
    }

    @Override
    public boolean isNodeQuotaAsync(String repositoryName, String workspaceName, String nodePath) throws UnknownQuotaLimitException {
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        NodeQuotaKey key = new NodeQuotaKey(workspaceUniqueName, nodePath);
        return this.getQuotaValue(key).getAsyncUpdate();
    }

    @Override
    public boolean isGroupOfNodesQuotaAsync(String repositoryName, String workspaceName, String patternPath) throws UnknownQuotaLimitException {
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        GroupOfNodesQuotaKey key = new GroupOfNodesQuotaKey(workspaceUniqueName, patternPath);
        return this.getQuotaValue(key).getAsyncUpdate();
    }

    @Override
    public Set<String> getAllNodeQuota(String repositoryName, String workspaceName) {
        HashSet<String> pathes = new HashSet<String>();
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        for (Serializable cacheKey : this.cache.keySet()) {
            if (!(cacheKey instanceof NodeQuotaKey) || !workspaceUniqueName.equals(((WorkspaceBasedKey)cacheKey).getWorkspaceUniqueName())) continue;
            pathes.add(((PathBasedKey)cacheKey).getPath());
        }
        return pathes;
    }

    @Override
    public Set<String> getAllGroupOfNodesQuota(String repositoryName, String workspaceName) {
        HashSet<String> pathes = new HashSet<String>();
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        for (Serializable cacheKey : this.cache.keySet()) {
            if (!(cacheKey instanceof GroupOfNodesQuotaKey) || !workspaceUniqueName.equals(((WorkspaceBasedKey)cacheKey).getWorkspaceUniqueName())) continue;
            pathes.add(((PathBasedKey)cacheKey).getPath());
        }
        return pathes;
    }

    @Override
    public Set<String> getAllTrackedNodes(String repositoryName, String workspaceName) {
        HashSet<String> pathes = new HashSet<String>();
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        for (Serializable cacheKey : this.cache.keySet()) {
            if (!(cacheKey instanceof NodeDataSizeKey) || !workspaceUniqueName.equals(((WorkspaceBasedKey)cacheKey).getWorkspaceUniqueName())) continue;
            pathes.add(((PathBasedKey)cacheKey).getPath());
        }
        return pathes;
    }

    @Override
    public void removeNodeQuota(String repositoryName, String workspaceName, String nodePath) {
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        NodeQuotaKey key = new NodeQuotaKey(workspaceUniqueName, nodePath);
        this.cache.remove((Object)key);
    }

    @Override
    public void removeGroupOfNodesQuota(String repositoryName, String workspaceName, String patternPath) {
        String workspaceUniqueName = this.composeWorkspaceUniqueName(repositoryName, workspaceName);
        GroupOfNodesQuotaKey key = new GroupOfNodesQuotaKey(workspaceUniqueName, patternPath);
        this.cache.remove((Object)key);
    }

    private long getQuota(CacheKey key) throws UnknownQuotaLimitException {
        Long size = (Long)this.cache.withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get((Object)key);
        if (size == null) {
            throw new UnknownQuotaLimitException("Quota was not set early");
        }
        return size;
    }

    private QuotaValue getQuotaValue(final CacheKey key) throws UnknownQuotaLimitException {
        QuotaValue quotaValue = (QuotaValue)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<QuotaValue>(){

            @Override
            public QuotaValue run() {
                return (QuotaValue)ISPNQuotaPersister.this.cache.withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get((Object)key);
            }
        });
        if (quotaValue == null) {
            throw new UnknownQuotaLimitException("Quota was not set early");
        }
        return quotaValue;
    }

    private long getDataSize(final CacheKey key) throws UnknownDataSizeException {
        Long size = (Long)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return (Long)ISPNQuotaPersister.this.cache.withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get((Object)key);
            }
        });
        if (size == null) {
            throw new UnknownDataSizeException("Data size is unknown");
        }
        return size;
    }

    private String composeWorkspaceUniqueName(String repositoryName, String workspaceName) {
        StringBuilder builder = new StringBuilder();
        builder.append(repositoryName);
        builder.append('/');
        builder.append(workspaceName);
        builder.append('/');
        return builder.toString();
    }
}

