/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.init;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializer;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;

public class StorageDBInitializer
extends DBInitializer {
    public StorageDBInitializer(Connection connection, JDBCDataContainerConfig containerConfig) throws IOException {
        super(connection, containerConfig);
    }

    protected String updateQuery(String sql) {
        try {
            Matcher tMatcher;
            if (this.creatSequencePattern.matcher(sql).find()) {
                Matcher tMatcher2 = this.dbObjectNamePattern.matcher(sql);
                if (tMatcher2.find() && sql.substring(tMatcher2.start(), tMatcher2.end()).equals("JCR_" + DBInitializerHelper.getItemTableSuffix(this.containerConfig) + "_SEQ")) {
                    sql = this.containerConfig.useSequenceForOrderNumber ? sql.concat(" Start with " + Integer.toString(this.getSequenceStartValue(this.connection))) : "";
                }
            } else if (this.creatFunctionPattern.matcher(sql).find() || this.creatProcedurePattern.matcher(sql).find()) {
                Matcher tMatcher3 = this.dbObjectNamePattern.matcher(sql);
                if (tMatcher3.find() && sql.substring(tMatcher3.start(), tMatcher3.end()).equals("JCR_" + DBInitializerHelper.getItemTableSuffix(this.containerConfig) + "_NEXT_VAL") && !this.containerConfig.useSequenceForOrderNumber) {
                    sql = "";
                }
            } else if (this.creatTablePattern.matcher(sql).find() && (tMatcher = this.dbObjectNamePattern.matcher(sql)).find() && sql.substring(tMatcher.start(), tMatcher.end()).equals("JCR_" + DBInitializerHelper.getItemTableSuffix(this.containerConfig) + "_SEQ") && !this.containerConfig.useSequenceForOrderNumber) {
                sql = "";
            }
        }
        catch (SQLException e) {
            LOG.debug((Object)"SQLException occurs while update the sequence start value", (Throwable)e);
        }
        return sql;
    }

    protected int getSequenceStartValue(final Connection conn) throws SQLException {
        return (Integer)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return StorageDBInitializer.this.getStartValue(conn);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getStartValue(Connection con) {
        int n;
        ResultSet trs;
        Statement stmt;
        block9: {
            String query;
            block8: {
                stmt = null;
                trs = null;
                String tableItem = DBInitializerHelper.getItemTableName(this.containerConfig);
                if (JDBCUtils.tableExists((String)tableItem, (Connection)con)) {
                    query = "select max(N_ORDER_NUM) from " + tableItem;
                    break block8;
                }
                int n2 = -1;
                Object var8_11 = null;
                JDBCUtils.freeResources(trs, stmt, null);
                return n2;
            }
            stmt = con.createStatement();
            trs = stmt.executeQuery(query);
            if (!trs.next() || trs.getInt(1) < 0) break block9;
            int n3 = trs.getInt(1);
            Object var8_12 = null;
            JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
            return n3;
        }
        try {
            n = -1;
            Object var8_13 = null;
        }
        catch (SQLException e) {
            int n4;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"SQLException occurred while calculate the sequence start value", (Throwable)e);
                }
                n4 = -1;
                Object var8_14 = null;
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                JDBCUtils.freeResources(trs, stmt, null);
                throw throwable;
            }
            JDBCUtils.freeResources(trs, stmt, null);
            return n4;
        }
        JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
        return n;
    }
}

