/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.protocols.pbcast.ServerGmsImpl;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.Tuple;

public class CoordGmsImpl
extends ServerGmsImpl {
    private static final Long MAX_SUSPEND_TIMEOUT = 30000L;

    public CoordGmsImpl(GMS g) {
        super(g);
    }

    public MergeId getMergeId() {
        return this.merger.getMergeId();
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.merger.cancelMerge(null);
    }

    @Override
    public void join(Address mbr, boolean useFlushIfPresent) {
        this.wrongMethod("join");
    }

    @Override
    public void joinWithStateTransfer(Address mbr, boolean useFlushIfPresent) {
        this.wrongMethod("join");
    }

    @Override
    public void leave(Address mbr) {
        if (mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("member's address is null !");
            }
            return;
        }
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        this.gms.getViewHandler().add(new GmsImpl.Request(2, mbr, false));
        this.gms.getViewHandler().stop(true);
        long timeout = (long)((double)Math.max(this.gms.leave_timeout, this.gms.view_ack_collection_timeout) * 1.1);
        this.gms.getViewHandler().waitUntilCompleted(timeout);
    }

    @Override
    public void suspect(Address mbr) {
        if (mbr.equals(this.gms.local_addr)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("I am the coord and I'm suspected -- will probably leave shortly");
            }
            return;
        }
        LinkedHashSet<GmsImpl.Request> suspected = new LinkedHashSet<GmsImpl.Request>(1);
        suspected.add(new GmsImpl.Request(3, mbr, true));
        this.handleMembershipChange(suspected);
    }

    @Override
    public void merge(Map<Address, View> views) {
        this.merger.merge(views);
    }

    @Override
    public void handleMergeResponse(MergeData data, MergeId merge_id) {
        this.merger.handleMergeResponse(data, merge_id);
    }

    @Override
    public void handleMergeCancelled(MergeId merge_id) {
        this.merger.handleMergeCancelled(merge_id);
    }

    void fixDigests() {
        this.merger.fixDigests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMembershipChange(Collection<GmsImpl.Request> requests) {
        boolean joinAndStateTransferInitiated = false;
        boolean useFlushIfPresent = this.gms.use_flush_if_present;
        LinkedHashSet<Address> new_mbrs = new LinkedHashSet<Address>(requests.size());
        LinkedHashSet<Address> suspected_mbrs = new LinkedHashSet<Address>(requests.size());
        LinkedHashSet<Address> leaving_mbrs = new LinkedHashSet<Address>(requests.size());
        for (GmsImpl.Request req : requests) {
            switch (req.type) {
                case 1: {
                    new_mbrs.add(req.mbr);
                    useFlushIfPresent = req.useFlushIfPresent;
                    break;
                }
                case 6: {
                    new_mbrs.add(req.mbr);
                    joinAndStateTransferInitiated = true;
                    useFlushIfPresent = req.useFlushIfPresent;
                    break;
                }
                case 2: {
                    if (req.suspected) {
                        suspected_mbrs.add(req.mbr);
                        break;
                    }
                    leaving_mbrs.add(req.mbr);
                    break;
                }
                case 3: {
                    suspected_mbrs.add(req.mbr);
                }
            }
        }
        new_mbrs.remove(this.gms.local_addr);
        if (this.gms.getViewId() == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("gms.view_id is null, I'm not the coordinator anymore (leaving=" + String.valueOf(this.leaving) + "); the new coordinator will handle the leave request");
            }
            return;
        }
        List<Address> current_members = this.gms.members.getMembers();
        leaving_mbrs.retainAll(current_members);
        if (suspected_mbrs.remove(this.gms.local_addr) && this.log.isWarnEnabled()) {
            this.log.warn("I am the coord and I'm being suspected -- will probably leave shortly");
        }
        suspected_mbrs.retainAll(current_members);
        Iterator it = new_mbrs.iterator();
        while (it.hasNext()) {
            Tuple<View, Digest> tuple;
            Address mbr = (Address)it.next();
            if (!this.gms.members.contains(mbr)) continue;
            if (this.log.isWarnEnabled()) {
                this.log.warn(mbr + " already present; returning existing view " + this.gms.view);
            }
            if ((tuple = this.gms.getViewAndDigest()) != null) {
                JoinRsp join_rsp = new JoinRsp(tuple.getVal1(), tuple.getVal2());
                this.gms.sendJoinResponse(join_rsp, mbr);
            }
            it.remove();
        }
        if (new_mbrs.isEmpty() && leaving_mbrs.isEmpty() && suspected_mbrs.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("found no members to add or remove, will not create new view");
            }
            return;
        }
        View new_view = this.gms.getNextView(new_mbrs, leaving_mbrs, suspected_mbrs);
        if (new_view.size() == 0 && this.gms.local_addr != null && this.gms.local_addr.equals(new_view.getCreator())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("view " + new_view + " is empty: will not multicast it (last view)");
            }
            if (this.leaving) {
                this.gms.initState();
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.gms.local_addr + ": new members=" + new_mbrs + ", suspected=" + suspected_mbrs + ", leaving=" + leaving_mbrs + ", new view: " + new_view);
        }
        JoinRsp join_rsp = null;
        boolean hasJoiningMembers = !new_mbrs.isEmpty();
        try {
            boolean successfulFlush;
            boolean bl = successfulFlush = !useFlushIfPresent || !this.gms.flushProtocolInStack || this.gms.startFlush(new_view);
            if (!successfulFlush && hasJoiningMembers) {
                this.sendLeaveResponses(leaving_mbrs);
                return;
            }
            if (hasJoiningMembers) {
                this.gms.getDownProtocol().down(new Event(65, MAX_SUSPEND_TIMEOUT));
                Digest tmp = this.gms.getDigest();
                MutableDigest join_digest = null;
                if (tmp == null) {
                    this.log.error("received null digest from GET_DIGEST: will cause JOIN to fail");
                } else {
                    join_digest = new MutableDigest(tmp.size() + new_mbrs.size());
                    for (Digest.DigestEntry entry : tmp) {
                        Address mbr = entry.getMember();
                        if (!new_view.containsMember(mbr)) continue;
                        join_digest.add(mbr, entry.getHighestDeliveredSeqno(), entry.getHighestReceivedSeqno(), false);
                    }
                    for (Address member : new_mbrs) {
                        join_digest.add(member, 0L, 0L);
                    }
                }
                join_rsp = new JoinRsp(new_view, join_digest != null ? join_digest.copy() : null);
            }
            this.sendLeaveResponses(leaving_mbrs);
            this.gms.castViewChange(new_view, join_rsp != null ? join_rsp.getDigest() : null, join_rsp, new_mbrs);
        }
        finally {
            if (hasJoiningMembers) {
                this.gms.getDownProtocol().down(new Event(66));
            }
            if (!joinAndStateTransferInitiated && useFlushIfPresent) {
                this.gms.stopFlush();
            }
            if (this.leaving) {
                this.gms.initState();
            }
        }
    }

    @Override
    public void handleViewChange(View new_view, Digest digest) {
        List<Address> mbrs = new_view.getMembers();
        if (this.leaving && !mbrs.contains(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    @Override
    public void stop() {
        super.stop();
        this.merger.stop();
    }

    private void sendLeaveResponses(Collection<Address> leaving_members) {
        for (Address address : leaving_members) {
            Message msg = new Message(address, null, null);
            msg.setFlag(Message.OOB);
            GMS.GmsHeader hdr = new GMS.GmsHeader(4);
            msg.putHeader(this.gms.getId(), hdr);
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
    }
}

